package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineOSBuildStatusFluent<A extends MachineOSBuildStatusFluent<A>> extends BaseFluent<A>{
  public MachineOSBuildStatusFluent() {
  }
  
  public MachineOSBuildStatusFluent(MachineOSBuildStatus instance) {
    this.copyInstance(instance);
  }
  private String buildEnd;
  private String buildStart;
  private MachineOSBuilderReferenceBuilder builderReference;
  private List<Condition> conditions = new ArrayList<Condition>();
  private String finalImagePullspec;
  private ArrayList<ObjectReferenceBuilder> relatedObjects = new ArrayList<ObjectReferenceBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineOSBuildStatus instance) {
    instance = (instance != null ? instance : new MachineOSBuildStatus());
    if (instance != null) {
          this.withBuildEnd(instance.getBuildEnd());
          this.withBuildStart(instance.getBuildStart());
          this.withBuilderReference(instance.getBuilderReference());
          this.withConditions(instance.getConditions());
          this.withFinalImagePullspec(instance.getFinalImagePullspec());
          this.withRelatedObjects(instance.getRelatedObjects());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBuildEnd() {
    return this.buildEnd;
  }
  
  public A withBuildEnd(String buildEnd) {
    this.buildEnd = buildEnd;
    return (A) this;
  }
  
  public boolean hasBuildEnd() {
    return this.buildEnd != null;
  }
  
  public String getBuildStart() {
    return this.buildStart;
  }
  
  public A withBuildStart(String buildStart) {
    this.buildStart = buildStart;
    return (A) this;
  }
  
  public boolean hasBuildStart() {
    return this.buildStart != null;
  }
  
  public MachineOSBuilderReference buildBuilderReference() {
    return this.builderReference != null ? this.builderReference.build() : null;
  }
  
  public A withBuilderReference(MachineOSBuilderReference builderReference) {
    this._visitables.remove("builderReference");
    if (builderReference != null) {
        this.builderReference = new MachineOSBuilderReferenceBuilder(builderReference);
        this._visitables.get("builderReference").add(this.builderReference);
    } else {
        this.builderReference = null;
        this._visitables.get("builderReference").remove(this.builderReference);
    }
    return (A) this;
  }
  
  public boolean hasBuilderReference() {
    return this.builderReference != null;
  }
  
  public BuilderReferenceNested<A> withNewBuilderReference() {
    return new BuilderReferenceNested(null);
  }
  
  public BuilderReferenceNested<A> withNewBuilderReferenceLike(MachineOSBuilderReference item) {
    return new BuilderReferenceNested(item);
  }
  
  public BuilderReferenceNested<A> editBuilderReference() {
    return withNewBuilderReferenceLike(java.util.Optional.ofNullable(buildBuilderReference()).orElse(null));
  }
  
  public BuilderReferenceNested<A> editOrNewBuilderReference() {
    return withNewBuilderReferenceLike(java.util.Optional.ofNullable(buildBuilderReference()).orElse(new MachineOSBuilderReferenceBuilder().build()));
  }
  
  public BuilderReferenceNested<A> editOrNewBuilderReferenceLike(MachineOSBuilderReference item) {
    return withNewBuilderReferenceLike(java.util.Optional.ofNullable(buildBuilderReference()).orElse(item));
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public String getFinalImagePullspec() {
    return this.finalImagePullspec;
  }
  
  public A withFinalImagePullspec(String finalImagePullspec) {
    this.finalImagePullspec = finalImagePullspec;
    return (A) this;
  }
  
  public boolean hasFinalImagePullspec() {
    return this.finalImagePullspec != null;
  }
  
  public A addToRelatedObjects(int index,ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= relatedObjects.size()) { _visitables.get("relatedObjects").add(builder); relatedObjects.add(builder); } else { _visitables.get("relatedObjects").add(index, builder); relatedObjects.add(index, builder);}
    return (A)this;
  }
  
  public A setToRelatedObjects(int index,ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= relatedObjects.size()) { _visitables.get("relatedObjects").add(builder); relatedObjects.add(builder); } else { _visitables.get("relatedObjects").set(index, builder); relatedObjects.set(index, builder);}
    return (A)this;
  }
  
  public A addToRelatedObjects(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  
  public A addAllToRelatedObjects(Collection<ObjectReference> items) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  
  public A removeFromRelatedObjects(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.relatedObjects == null) return (A)this;
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder); this.relatedObjects.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRelatedObjects(Collection<ObjectReference> items) {
    if (this.relatedObjects == null) return (A)this;
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder); this.relatedObjects.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRelatedObjects(Predicate<ObjectReferenceBuilder> predicate) {
    if (relatedObjects == null) return (A) this;
    final Iterator<ObjectReferenceBuilder> each = relatedObjects.iterator();
    final List visitables = _visitables.get("relatedObjects");
    while (each.hasNext()) {
      ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ObjectReference> buildRelatedObjects() {
    return this.relatedObjects != null ? build(relatedObjects) : null;
  }
  
  public ObjectReference buildRelatedObject(int index) {
    return this.relatedObjects.get(index).build();
  }
  
  public ObjectReference buildFirstRelatedObject() {
    return this.relatedObjects.get(0).build();
  }
  
  public ObjectReference buildLastRelatedObject() {
    return this.relatedObjects.get(relatedObjects.size() - 1).build();
  }
  
  public ObjectReference buildMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
      for (ObjectReferenceBuilder item : relatedObjects) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
      for (ObjectReferenceBuilder item : relatedObjects) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRelatedObjects(List<ObjectReference> relatedObjects) {
    if (this.relatedObjects != null) {
      this._visitables.get("relatedObjects").clear();
    }
    if (relatedObjects != null) {
        this.relatedObjects = new ArrayList();
        for (ObjectReference item : relatedObjects) {
          this.addToRelatedObjects(item);
        }
    } else {
      this.relatedObjects = null;
    }
    return (A) this;
  }
  
  public A withRelatedObjects(io.fabric8.kubernetes.api.model.ObjectReference... relatedObjects) {
    if (this.relatedObjects != null) {
        this.relatedObjects.clear();
        _visitables.remove("relatedObjects");
    }
    if (relatedObjects != null) {
      for (ObjectReference item : relatedObjects) {
        this.addToRelatedObjects(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRelatedObjects() {
    return this.relatedObjects != null && !this.relatedObjects.isEmpty();
  }
  
  public RelatedObjectsNested<A> addNewRelatedObject() {
    return new RelatedObjectsNested(-1, null);
  }
  
  public RelatedObjectsNested<A> addNewRelatedObjectLike(ObjectReference item) {
    return new RelatedObjectsNested(-1, item);
  }
  
  public RelatedObjectsNested<A> setNewRelatedObjectLike(int index,ObjectReference item) {
    return new RelatedObjectsNested(index, item);
  }
  
  public RelatedObjectsNested<A> editRelatedObject(int index) {
    if (relatedObjects.size() <= index) throw new RuntimeException("Can't edit relatedObjects. Index exceeds size.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  
  public RelatedObjectsNested<A> editFirstRelatedObject() {
    if (relatedObjects.size() == 0) throw new RuntimeException("Can't edit first relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(0, buildRelatedObject(0));
  }
  
  public RelatedObjectsNested<A> editLastRelatedObject() {
    int index = relatedObjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  
  public RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relatedObjects.size();i++) { 
    if (predicate.test(relatedObjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relatedObjects. No match found.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineOSBuildStatusFluent that = (MachineOSBuildStatusFluent) o;
    if (!java.util.Objects.equals(buildEnd, that.buildEnd)) return false;
    if (!java.util.Objects.equals(buildStart, that.buildStart)) return false;
    if (!java.util.Objects.equals(builderReference, that.builderReference)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(finalImagePullspec, that.finalImagePullspec)) return false;
    if (!java.util.Objects.equals(relatedObjects, that.relatedObjects)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(buildEnd,  buildStart,  builderReference,  conditions,  finalImagePullspec,  relatedObjects,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (buildEnd != null) { sb.append("buildEnd:"); sb.append(buildEnd + ","); }
    if (buildStart != null) { sb.append("buildStart:"); sb.append(buildStart + ","); }
    if (builderReference != null) { sb.append("builderReference:"); sb.append(builderReference + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (finalImagePullspec != null) { sb.append("finalImagePullspec:"); sb.append(finalImagePullspec + ","); }
    if (relatedObjects != null && !relatedObjects.isEmpty()) { sb.append("relatedObjects:"); sb.append(relatedObjects + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BuilderReferenceNested<N> extends MachineOSBuilderReferenceFluent<BuilderReferenceNested<N>> implements Nested<N>{
    BuilderReferenceNested(MachineOSBuilderReference item) {
      this.builder = new MachineOSBuilderReferenceBuilder(this, item);
    }
    MachineOSBuilderReferenceBuilder builder;
    
    public N and() {
      return (N) MachineOSBuildStatusFluent.this.withBuilderReference(builder.build());
    }
    
    public N endBuilderReference() {
      return and();
    }
    
  
  }
  public class RelatedObjectsNested<N> extends ObjectReferenceFluent<RelatedObjectsNested<N>> implements Nested<N>{
    RelatedObjectsNested(int index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) MachineOSBuildStatusFluent.this.setToRelatedObjects(index,builder.build());
    }
    
    public N endRelatedObject() {
      return and();
    }
    
  
  }

}