package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BuildOutputsBuilder extends BuildOutputsFluent<BuildOutputsBuilder> implements VisitableBuilder<BuildOutputs,BuildOutputsBuilder>{
  public BuildOutputsBuilder() {
    this(new BuildOutputs());
  }
  
  public BuildOutputsBuilder(BuildOutputsFluent<?> fluent) {
    this(fluent, new BuildOutputs());
  }
  
  public BuildOutputsBuilder(BuildOutputsFluent<?> fluent,BuildOutputs instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BuildOutputsBuilder(BuildOutputs instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BuildOutputsFluent<?> fluent;
  
  public BuildOutputs build() {
    BuildOutputs buildable = new BuildOutputs(fluent.buildCurrentImagePullSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}