package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildInputsFluent<A extends BuildInputsFluent<A>> extends BaseFluent<A>{
  public BuildInputsFluent() {
  }
  
  public BuildInputsFluent(BuildInputs instance) {
    this.copyInstance(instance);
  }
  private ImageSecretObjectReferenceBuilder baseImagePullSecret;
  private String baseOSExtensionsImagePullspec;
  private String baseOSImagePullspec;
  private ArrayList<MachineOSContainerfileBuilder> containerFile = new ArrayList<MachineOSContainerfileBuilder>();
  private MachineOSImageBuilderBuilder imageBuilder;
  private String releaseVersion;
  private ImageSecretObjectReferenceBuilder renderedImagePushSecret;
  private String renderedImagePushspec;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BuildInputs instance) {
    instance = (instance != null ? instance : new BuildInputs());
    if (instance != null) {
          this.withBaseImagePullSecret(instance.getBaseImagePullSecret());
          this.withBaseOSExtensionsImagePullspec(instance.getBaseOSExtensionsImagePullspec());
          this.withBaseOSImagePullspec(instance.getBaseOSImagePullspec());
          this.withContainerFile(instance.getContainerFile());
          this.withImageBuilder(instance.getImageBuilder());
          this.withReleaseVersion(instance.getReleaseVersion());
          this.withRenderedImagePushSecret(instance.getRenderedImagePushSecret());
          this.withRenderedImagePushspec(instance.getRenderedImagePushspec());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ImageSecretObjectReference buildBaseImagePullSecret() {
    return this.baseImagePullSecret != null ? this.baseImagePullSecret.build() : null;
  }
  
  public A withBaseImagePullSecret(ImageSecretObjectReference baseImagePullSecret) {
    this._visitables.remove("baseImagePullSecret");
    if (baseImagePullSecret != null) {
        this.baseImagePullSecret = new ImageSecretObjectReferenceBuilder(baseImagePullSecret);
        this._visitables.get("baseImagePullSecret").add(this.baseImagePullSecret);
    } else {
        this.baseImagePullSecret = null;
        this._visitables.get("baseImagePullSecret").remove(this.baseImagePullSecret);
    }
    return (A) this;
  }
  
  public boolean hasBaseImagePullSecret() {
    return this.baseImagePullSecret != null;
  }
  
  public A withNewBaseImagePullSecret(String name) {
    return (A)withBaseImagePullSecret(new ImageSecretObjectReference(name));
  }
  
  public BaseImagePullSecretNested<A> withNewBaseImagePullSecret() {
    return new BaseImagePullSecretNested(null);
  }
  
  public BaseImagePullSecretNested<A> withNewBaseImagePullSecretLike(ImageSecretObjectReference item) {
    return new BaseImagePullSecretNested(item);
  }
  
  public BaseImagePullSecretNested<A> editBaseImagePullSecret() {
    return withNewBaseImagePullSecretLike(java.util.Optional.ofNullable(buildBaseImagePullSecret()).orElse(null));
  }
  
  public BaseImagePullSecretNested<A> editOrNewBaseImagePullSecret() {
    return withNewBaseImagePullSecretLike(java.util.Optional.ofNullable(buildBaseImagePullSecret()).orElse(new ImageSecretObjectReferenceBuilder().build()));
  }
  
  public BaseImagePullSecretNested<A> editOrNewBaseImagePullSecretLike(ImageSecretObjectReference item) {
    return withNewBaseImagePullSecretLike(java.util.Optional.ofNullable(buildBaseImagePullSecret()).orElse(item));
  }
  
  public String getBaseOSExtensionsImagePullspec() {
    return this.baseOSExtensionsImagePullspec;
  }
  
  public A withBaseOSExtensionsImagePullspec(String baseOSExtensionsImagePullspec) {
    this.baseOSExtensionsImagePullspec = baseOSExtensionsImagePullspec;
    return (A) this;
  }
  
  public boolean hasBaseOSExtensionsImagePullspec() {
    return this.baseOSExtensionsImagePullspec != null;
  }
  
  public String getBaseOSImagePullspec() {
    return this.baseOSImagePullspec;
  }
  
  public A withBaseOSImagePullspec(String baseOSImagePullspec) {
    this.baseOSImagePullspec = baseOSImagePullspec;
    return (A) this;
  }
  
  public boolean hasBaseOSImagePullspec() {
    return this.baseOSImagePullspec != null;
  }
  
  public A addToContainerFile(int index,MachineOSContainerfile item) {
    if (this.containerFile == null) {this.containerFile = new ArrayList<MachineOSContainerfileBuilder>();}
    MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);
    if (index < 0 || index >= containerFile.size()) { _visitables.get("containerFile").add(builder); containerFile.add(builder); } else { _visitables.get("containerFile").add(index, builder); containerFile.add(index, builder);}
    return (A)this;
  }
  
  public A setToContainerFile(int index,MachineOSContainerfile item) {
    if (this.containerFile == null) {this.containerFile = new ArrayList<MachineOSContainerfileBuilder>();}
    MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);
    if (index < 0 || index >= containerFile.size()) { _visitables.get("containerFile").add(builder); containerFile.add(builder); } else { _visitables.get("containerFile").set(index, builder); containerFile.set(index, builder);}
    return (A)this;
  }
  
  public A addToContainerFile(io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSContainerfile... items) {
    if (this.containerFile == null) {this.containerFile = new ArrayList<MachineOSContainerfileBuilder>();}
    for (MachineOSContainerfile item : items) {MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);_visitables.get("containerFile").add(builder);this.containerFile.add(builder);} return (A)this;
  }
  
  public A addAllToContainerFile(Collection<MachineOSContainerfile> items) {
    if (this.containerFile == null) {this.containerFile = new ArrayList<MachineOSContainerfileBuilder>();}
    for (MachineOSContainerfile item : items) {MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);_visitables.get("containerFile").add(builder);this.containerFile.add(builder);} return (A)this;
  }
  
  public A removeFromContainerFile(io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSContainerfile... items) {
    if (this.containerFile == null) return (A)this;
    for (MachineOSContainerfile item : items) {MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);_visitables.get("containerFile").remove(builder); this.containerFile.remove(builder);} return (A)this;
  }
  
  public A removeAllFromContainerFile(Collection<MachineOSContainerfile> items) {
    if (this.containerFile == null) return (A)this;
    for (MachineOSContainerfile item : items) {MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);_visitables.get("containerFile").remove(builder); this.containerFile.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromContainerFile(Predicate<MachineOSContainerfileBuilder> predicate) {
    if (containerFile == null) return (A) this;
    final Iterator<MachineOSContainerfileBuilder> each = containerFile.iterator();
    final List visitables = _visitables.get("containerFile");
    while (each.hasNext()) {
      MachineOSContainerfileBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MachineOSContainerfile> buildContainerFile() {
    return this.containerFile != null ? build(containerFile) : null;
  }
  
  public MachineOSContainerfile buildContainerFile(int index) {
    return this.containerFile.get(index).build();
  }
  
  public MachineOSContainerfile buildFirstContainerFile() {
    return this.containerFile.get(0).build();
  }
  
  public MachineOSContainerfile buildLastContainerFile() {
    return this.containerFile.get(containerFile.size() - 1).build();
  }
  
  public MachineOSContainerfile buildMatchingContainerFile(Predicate<MachineOSContainerfileBuilder> predicate) {
      for (MachineOSContainerfileBuilder item : containerFile) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingContainerFile(Predicate<MachineOSContainerfileBuilder> predicate) {
      for (MachineOSContainerfileBuilder item : containerFile) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withContainerFile(List<MachineOSContainerfile> containerFile) {
    if (this.containerFile != null) {
      this._visitables.get("containerFile").clear();
    }
    if (containerFile != null) {
        this.containerFile = new ArrayList();
        for (MachineOSContainerfile item : containerFile) {
          this.addToContainerFile(item);
        }
    } else {
      this.containerFile = null;
    }
    return (A) this;
  }
  
  public A withContainerFile(io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSContainerfile... containerFile) {
    if (this.containerFile != null) {
        this.containerFile.clear();
        _visitables.remove("containerFile");
    }
    if (containerFile != null) {
      for (MachineOSContainerfile item : containerFile) {
        this.addToContainerFile(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasContainerFile() {
    return this.containerFile != null && !this.containerFile.isEmpty();
  }
  
  public A addNewContainerFile(String containerfileArch,String content) {
    return (A)addToContainerFile(new MachineOSContainerfile(containerfileArch, content));
  }
  
  public ContainerFileNested<A> addNewContainerFile() {
    return new ContainerFileNested(-1, null);
  }
  
  public ContainerFileNested<A> addNewContainerFileLike(MachineOSContainerfile item) {
    return new ContainerFileNested(-1, item);
  }
  
  public ContainerFileNested<A> setNewContainerFileLike(int index,MachineOSContainerfile item) {
    return new ContainerFileNested(index, item);
  }
  
  public ContainerFileNested<A> editContainerFile(int index) {
    if (containerFile.size() <= index) throw new RuntimeException("Can't edit containerFile. Index exceeds size.");
    return setNewContainerFileLike(index, buildContainerFile(index));
  }
  
  public ContainerFileNested<A> editFirstContainerFile() {
    if (containerFile.size() == 0) throw new RuntimeException("Can't edit first containerFile. The list is empty.");
    return setNewContainerFileLike(0, buildContainerFile(0));
  }
  
  public ContainerFileNested<A> editLastContainerFile() {
    int index = containerFile.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containerFile. The list is empty.");
    return setNewContainerFileLike(index, buildContainerFile(index));
  }
  
  public ContainerFileNested<A> editMatchingContainerFile(Predicate<MachineOSContainerfileBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containerFile.size();i++) { 
    if (predicate.test(containerFile.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containerFile. No match found.");
    return setNewContainerFileLike(index, buildContainerFile(index));
  }
  
  public MachineOSImageBuilder buildImageBuilder() {
    return this.imageBuilder != null ? this.imageBuilder.build() : null;
  }
  
  public A withImageBuilder(MachineOSImageBuilder imageBuilder) {
    this._visitables.remove("imageBuilder");
    if (imageBuilder != null) {
        this.imageBuilder = new MachineOSImageBuilderBuilder(imageBuilder);
        this._visitables.get("imageBuilder").add(this.imageBuilder);
    } else {
        this.imageBuilder = null;
        this._visitables.get("imageBuilder").remove(this.imageBuilder);
    }
    return (A) this;
  }
  
  public boolean hasImageBuilder() {
    return this.imageBuilder != null;
  }
  
  public A withNewImageBuilder(String imageBuilderType) {
    return (A)withImageBuilder(new MachineOSImageBuilder(imageBuilderType));
  }
  
  public ImageBuilderNested<A> withNewImageBuilder() {
    return new ImageBuilderNested(null);
  }
  
  public ImageBuilderNested<A> withNewImageBuilderLike(MachineOSImageBuilder item) {
    return new ImageBuilderNested(item);
  }
  
  public ImageBuilderNested<A> editImageBuilder() {
    return withNewImageBuilderLike(java.util.Optional.ofNullable(buildImageBuilder()).orElse(null));
  }
  
  public ImageBuilderNested<A> editOrNewImageBuilder() {
    return withNewImageBuilderLike(java.util.Optional.ofNullable(buildImageBuilder()).orElse(new MachineOSImageBuilderBuilder().build()));
  }
  
  public ImageBuilderNested<A> editOrNewImageBuilderLike(MachineOSImageBuilder item) {
    return withNewImageBuilderLike(java.util.Optional.ofNullable(buildImageBuilder()).orElse(item));
  }
  
  public String getReleaseVersion() {
    return this.releaseVersion;
  }
  
  public A withReleaseVersion(String releaseVersion) {
    this.releaseVersion = releaseVersion;
    return (A) this;
  }
  
  public boolean hasReleaseVersion() {
    return this.releaseVersion != null;
  }
  
  public ImageSecretObjectReference buildRenderedImagePushSecret() {
    return this.renderedImagePushSecret != null ? this.renderedImagePushSecret.build() : null;
  }
  
  public A withRenderedImagePushSecret(ImageSecretObjectReference renderedImagePushSecret) {
    this._visitables.remove("renderedImagePushSecret");
    if (renderedImagePushSecret != null) {
        this.renderedImagePushSecret = new ImageSecretObjectReferenceBuilder(renderedImagePushSecret);
        this._visitables.get("renderedImagePushSecret").add(this.renderedImagePushSecret);
    } else {
        this.renderedImagePushSecret = null;
        this._visitables.get("renderedImagePushSecret").remove(this.renderedImagePushSecret);
    }
    return (A) this;
  }
  
  public boolean hasRenderedImagePushSecret() {
    return this.renderedImagePushSecret != null;
  }
  
  public A withNewRenderedImagePushSecret(String name) {
    return (A)withRenderedImagePushSecret(new ImageSecretObjectReference(name));
  }
  
  public RenderedImagePushSecretNested<A> withNewRenderedImagePushSecret() {
    return new RenderedImagePushSecretNested(null);
  }
  
  public RenderedImagePushSecretNested<A> withNewRenderedImagePushSecretLike(ImageSecretObjectReference item) {
    return new RenderedImagePushSecretNested(item);
  }
  
  public RenderedImagePushSecretNested<A> editRenderedImagePushSecret() {
    return withNewRenderedImagePushSecretLike(java.util.Optional.ofNullable(buildRenderedImagePushSecret()).orElse(null));
  }
  
  public RenderedImagePushSecretNested<A> editOrNewRenderedImagePushSecret() {
    return withNewRenderedImagePushSecretLike(java.util.Optional.ofNullable(buildRenderedImagePushSecret()).orElse(new ImageSecretObjectReferenceBuilder().build()));
  }
  
  public RenderedImagePushSecretNested<A> editOrNewRenderedImagePushSecretLike(ImageSecretObjectReference item) {
    return withNewRenderedImagePushSecretLike(java.util.Optional.ofNullable(buildRenderedImagePushSecret()).orElse(item));
  }
  
  public String getRenderedImagePushspec() {
    return this.renderedImagePushspec;
  }
  
  public A withRenderedImagePushspec(String renderedImagePushspec) {
    this.renderedImagePushspec = renderedImagePushspec;
    return (A) this;
  }
  
  public boolean hasRenderedImagePushspec() {
    return this.renderedImagePushspec != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildInputsFluent that = (BuildInputsFluent) o;
    if (!java.util.Objects.equals(baseImagePullSecret, that.baseImagePullSecret)) return false;
    if (!java.util.Objects.equals(baseOSExtensionsImagePullspec, that.baseOSExtensionsImagePullspec)) return false;
    if (!java.util.Objects.equals(baseOSImagePullspec, that.baseOSImagePullspec)) return false;
    if (!java.util.Objects.equals(containerFile, that.containerFile)) return false;
    if (!java.util.Objects.equals(imageBuilder, that.imageBuilder)) return false;
    if (!java.util.Objects.equals(releaseVersion, that.releaseVersion)) return false;
    if (!java.util.Objects.equals(renderedImagePushSecret, that.renderedImagePushSecret)) return false;
    if (!java.util.Objects.equals(renderedImagePushspec, that.renderedImagePushspec)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(baseImagePullSecret,  baseOSExtensionsImagePullspec,  baseOSImagePullspec,  containerFile,  imageBuilder,  releaseVersion,  renderedImagePushSecret,  renderedImagePushspec,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseImagePullSecret != null) { sb.append("baseImagePullSecret:"); sb.append(baseImagePullSecret + ","); }
    if (baseOSExtensionsImagePullspec != null) { sb.append("baseOSExtensionsImagePullspec:"); sb.append(baseOSExtensionsImagePullspec + ","); }
    if (baseOSImagePullspec != null) { sb.append("baseOSImagePullspec:"); sb.append(baseOSImagePullspec + ","); }
    if (containerFile != null && !containerFile.isEmpty()) { sb.append("containerFile:"); sb.append(containerFile + ","); }
    if (imageBuilder != null) { sb.append("imageBuilder:"); sb.append(imageBuilder + ","); }
    if (releaseVersion != null) { sb.append("releaseVersion:"); sb.append(releaseVersion + ","); }
    if (renderedImagePushSecret != null) { sb.append("renderedImagePushSecret:"); sb.append(renderedImagePushSecret + ","); }
    if (renderedImagePushspec != null) { sb.append("renderedImagePushspec:"); sb.append(renderedImagePushspec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BaseImagePullSecretNested<N> extends ImageSecretObjectReferenceFluent<BaseImagePullSecretNested<N>> implements Nested<N>{
    BaseImagePullSecretNested(ImageSecretObjectReference item) {
      this.builder = new ImageSecretObjectReferenceBuilder(this, item);
    }
    ImageSecretObjectReferenceBuilder builder;
    
    public N and() {
      return (N) BuildInputsFluent.this.withBaseImagePullSecret(builder.build());
    }
    
    public N endBaseImagePullSecret() {
      return and();
    }
    
  
  }
  public class ContainerFileNested<N> extends MachineOSContainerfileFluent<ContainerFileNested<N>> implements Nested<N>{
    ContainerFileNested(int index,MachineOSContainerfile item) {
      this.index = index;
      this.builder = new MachineOSContainerfileBuilder(this, item);
    }
    MachineOSContainerfileBuilder builder;
    int index;
    
    public N and() {
      return (N) BuildInputsFluent.this.setToContainerFile(index,builder.build());
    }
    
    public N endContainerFile() {
      return and();
    }
    
  
  }
  public class ImageBuilderNested<N> extends MachineOSImageBuilderFluent<ImageBuilderNested<N>> implements Nested<N>{
    ImageBuilderNested(MachineOSImageBuilder item) {
      this.builder = new MachineOSImageBuilderBuilder(this, item);
    }
    MachineOSImageBuilderBuilder builder;
    
    public N and() {
      return (N) BuildInputsFluent.this.withImageBuilder(builder.build());
    }
    
    public N endImageBuilder() {
      return and();
    }
    
  
  }
  public class RenderedImagePushSecretNested<N> extends ImageSecretObjectReferenceFluent<RenderedImagePushSecretNested<N>> implements Nested<N>{
    RenderedImagePushSecretNested(ImageSecretObjectReference item) {
      this.builder = new ImageSecretObjectReferenceBuilder(this, item);
    }
    ImageSecretObjectReferenceBuilder builder;
    
    public N and() {
      return (N) BuildInputsFluent.this.withRenderedImagePushSecret(builder.build());
    }
    
    public N endRenderedImagePushSecret() {
      return and();
    }
    
  
  }

}