package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineConfigSpecBuilder extends MachineConfigSpecFluentImpl<MachineConfigSpecBuilder> implements VisitableBuilder<MachineConfigSpec,MachineConfigSpecBuilder>{
  public MachineConfigSpecBuilder() {
    this(false);
  }
  public MachineConfigSpecBuilder(Boolean validationEnabled) {
    this(new MachineConfigSpec(), validationEnabled);
  }
  public MachineConfigSpecBuilder(MachineConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineConfigSpecBuilder(MachineConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineConfigSpec(), validationEnabled);
  }
  public MachineConfigSpecBuilder(MachineConfigSpecFluent<?> fluent,MachineConfigSpec instance) {
    this(fluent, instance, false);
  }
  public MachineConfigSpecBuilder(MachineConfigSpecFluent<?> fluent,MachineConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfig(instance.getConfig());
      fluent.withExtensions(instance.getExtensions());
      fluent.withFips(instance.getFips());
      fluent.withKernelArguments(instance.getKernelArguments());
      fluent.withKernelType(instance.getKernelType());
      fluent.withOsImageURL(instance.getOsImageURL());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineConfigSpecBuilder(MachineConfigSpec instance) {
    this(instance,false);
  }
  public MachineConfigSpecBuilder(MachineConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfig(instance.getConfig());
      this.withExtensions(instance.getExtensions());
      this.withFips(instance.getFips());
      this.withKernelArguments(instance.getKernelArguments());
      this.withKernelType(instance.getKernelType());
      this.withOsImageURL(instance.getOsImageURL());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MachineConfigSpec build() {
    MachineConfigSpec buildable = new MachineConfigSpec(fluent.getConfig(),fluent.getExtensions(),fluent.getFips(),fluent.getKernelArguments(),fluent.getKernelType(),fluent.getOsImageURL());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}