package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface MachineConfigPoolStatusFluent<A extends MachineConfigPoolStatusFluent<A>> extends Fluent<A>{
  public A addToConditions(int index,MachineConfigPoolCondition item);
  public A setToConditions(int index,MachineConfigPoolCondition item);
  public A addToConditions(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolCondition... items);
  public A addAllToConditions(Collection<MachineConfigPoolCondition> items);
  public A removeFromConditions(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolCondition... items);
  public A removeAllFromConditions(Collection<MachineConfigPoolCondition> items);
  public A removeMatchingFromConditions(Predicate<MachineConfigPoolConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MachineConfigPoolCondition> getConditions();
  public List<MachineConfigPoolCondition> buildConditions();
  public MachineConfigPoolCondition buildCondition(int index);
  public MachineConfigPoolCondition buildFirstCondition();
  public MachineConfigPoolCondition buildLastCondition();
  public MachineConfigPoolCondition buildMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate);
  public A withConditions(List<MachineConfigPoolCondition> conditions);
  public A withConditions(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolCondition... conditions);
  public Boolean hasConditions();
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
  public MachineConfigPoolStatusFluent.ConditionsNested<A> addNewCondition();
  public MachineConfigPoolStatusFluent.ConditionsNested<A> addNewConditionLike(MachineConfigPoolCondition item);
  public MachineConfigPoolStatusFluent.ConditionsNested<A> setNewConditionLike(int index,MachineConfigPoolCondition item);
  public MachineConfigPoolStatusFluent.ConditionsNested<A> editCondition(int index);
  public MachineConfigPoolStatusFluent.ConditionsNested<A> editFirstCondition();
  public MachineConfigPoolStatusFluent.ConditionsNested<A> editLastCondition();
  public MachineConfigPoolStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachineConfigPoolStatusConfiguration getConfiguration();
  public MachineConfigPoolStatusConfiguration buildConfiguration();
  public A withConfiguration(MachineConfigPoolStatusConfiguration configuration);
  public Boolean hasConfiguration();
  public MachineConfigPoolStatusFluent.ConfigurationNested<A> withNewConfiguration();
  public MachineConfigPoolStatusFluent.ConfigurationNested<A> withNewConfigurationLike(MachineConfigPoolStatusConfiguration item);
  public MachineConfigPoolStatusFluent.ConfigurationNested<A> editConfiguration();
  public MachineConfigPoolStatusFluent.ConfigurationNested<A> editOrNewConfiguration();
  public MachineConfigPoolStatusFluent.ConfigurationNested<A> editOrNewConfigurationLike(MachineConfigPoolStatusConfiguration item);
  public Integer getDegradedMachineCount();
  public A withDegradedMachineCount(Integer degradedMachineCount);
  public Boolean hasDegradedMachineCount();
  public Integer getMachineCount();
  public A withMachineCount(Integer machineCount);
  public Boolean hasMachineCount();
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public Integer getReadyMachineCount();
  public A withReadyMachineCount(Integer readyMachineCount);
  public Boolean hasReadyMachineCount();
  public Integer getUnavailableMachineCount();
  public A withUnavailableMachineCount(Integer unavailableMachineCount);
  public Boolean hasUnavailableMachineCount();
  public Integer getUpdatedMachineCount();
  public A withUpdatedMachineCount(Integer updatedMachineCount);
  public Boolean hasUpdatedMachineCount();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,MachineConfigPoolConditionFluent<MachineConfigPoolStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface ConfigurationNested<N> extends Nested<N>,MachineConfigPoolStatusConfigurationFluent<MachineConfigPoolStatusFluent.ConfigurationNested<N>>{
    public N and();
    public N endConfiguration();
    
  }
  
}