package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachineConfigPoolStatusConfigurationFluentImpl<A extends MachineConfigPoolStatusConfigurationFluent<A>> extends BaseFluent<A> implements MachineConfigPoolStatusConfigurationFluent<A>{
  public MachineConfigPoolStatusConfigurationFluentImpl() {
  }
  public MachineConfigPoolStatusConfigurationFluentImpl(MachineConfigPoolStatusConfiguration instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withFieldPath(instance.getFieldPath());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResourceVersion(instance.getResourceVersion());
      this.withSource(instance.getSource());
      this.withUid(instance.getUid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String fieldPath;
  private String kind;
  private String name;
  private String namespace;
  private String resourceVersion;
  private ArrayList<ObjectReferenceBuilder> source = new ArrayList<ObjectReferenceBuilder>();
  private String uid;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getFieldPath() {
    return this.fieldPath;
  }
  public A withFieldPath(String fieldPath) {
    this.fieldPath=fieldPath; return (A) this;
  }
  public Boolean hasFieldPath() {
    return this.fieldPath != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public String getResourceVersion() {
    return this.resourceVersion;
  }
  public A withResourceVersion(String resourceVersion) {
    this.resourceVersion=resourceVersion; return (A) this;
  }
  public Boolean hasResourceVersion() {
    return this.resourceVersion != null;
  }
  public A addToSource(int index,ObjectReference item) {
    if (this.source == null) {this.source = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= source.size()) { _visitables.get("source").add(builder); source.add(builder); } else { _visitables.get("source").add(index, builder); source.add(index, builder);}
    return (A)this;
  }
  public A setToSource(int index,ObjectReference item) {
    if (this.source == null) {this.source = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= source.size()) { _visitables.get("source").add(builder); source.add(builder); } else { _visitables.get("source").set(index, builder); source.set(index, builder);}
    return (A)this;
  }
  public A addToSource(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.source == null) {this.source = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("source").add(builder);this.source.add(builder);} return (A)this;
  }
  public A addAllToSource(Collection<ObjectReference> items) {
    if (this.source == null) {this.source = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("source").add(builder);this.source.add(builder);} return (A)this;
  }
  public A removeFromSource(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("source").remove(builder);if (this.source != null) {this.source.remove(builder);}} return (A)this;
  }
  public A removeAllFromSource(Collection<ObjectReference> items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("source").remove(builder);if (this.source != null) {this.source.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSource(Predicate<ObjectReferenceBuilder> predicate) {
    if (source == null) return (A) this;
    final Iterator<ObjectReferenceBuilder> each = source.iterator();
    final List visitables = _visitables.get("source");
    while (each.hasNext()) {
      ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ObjectReference> getSource() {
    return source != null ? build(source) : null;
  }
  public List<ObjectReference> buildSource() {
    return source != null ? build(source) : null;
  }
  public ObjectReference buildSource(int index) {
    return this.source.get(index).build();
  }
  public ObjectReference buildFirstSource() {
    return this.source.get(0).build();
  }
  public ObjectReference buildLastSource() {
    return this.source.get(source.size() - 1).build();
  }
  public ObjectReference buildMatchingSource(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: source) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSource(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: source) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSource(List<ObjectReference> source) {
    if (this.source != null) { _visitables.get("source").clear();}
    if (source != null) {this.source = new ArrayList(); for (ObjectReference item : source){this.addToSource(item);}} else { this.source = null;} return (A) this;
  }
  public A withSource(io.fabric8.kubernetes.api.model.ObjectReference... source) {
    if (this.source != null) {this.source.clear(); _visitables.remove("source"); }
    if (source != null) {for (ObjectReference item :source){ this.addToSource(item);}} return (A) this;
  }
  public Boolean hasSource() {
    return source != null && !source.isEmpty();
  }
  public MachineConfigPoolStatusConfigurationFluentImpl.SourceNested<A> addNewSource() {
    return new MachineConfigPoolStatusConfigurationFluentImpl.SourceNestedImpl();
  }
  public MachineConfigPoolStatusConfigurationFluentImpl.SourceNested<A> addNewSourceLike(ObjectReference item) {
    return new MachineConfigPoolStatusConfigurationFluentImpl.SourceNestedImpl(-1, item);
  }
  public MachineConfigPoolStatusConfigurationFluentImpl.SourceNested<A> setNewSourceLike(int index,ObjectReference item) {
    return new MachineConfigPoolStatusConfigurationFluentImpl.SourceNestedImpl(index, item);
  }
  public MachineConfigPoolStatusConfigurationFluentImpl.SourceNested<A> editSource(int index) {
    if (source.size() <= index) throw new RuntimeException("Can't edit source. Index exceeds size.");
    return setNewSourceLike(index, buildSource(index));
  }
  public MachineConfigPoolStatusConfigurationFluentImpl.SourceNested<A> editFirstSource() {
    if (source.size() == 0) throw new RuntimeException("Can't edit first source. The list is empty.");
    return setNewSourceLike(0, buildSource(0));
  }
  public MachineConfigPoolStatusConfigurationFluentImpl.SourceNested<A> editLastSource() {
    int index = source.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last source. The list is empty.");
    return setNewSourceLike(index, buildSource(index));
  }
  public MachineConfigPoolStatusConfigurationFluentImpl.SourceNested<A> editMatchingSource(Predicate<ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<source.size();i++) { 
    if (predicate.test(source.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching source. No match found.");
    return setNewSourceLike(index, buildSource(index));
  }
  public String getUid() {
    return this.uid;
  }
  public A withUid(String uid) {
    this.uid=uid; return (A) this;
  }
  public Boolean hasUid() {
    return this.uid != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineConfigPoolStatusConfigurationFluentImpl that = (MachineConfigPoolStatusConfigurationFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(fieldPath, that.fieldPath)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(namespace, that.namespace)) return false;

    if (!java.util.Objects.equals(resourceVersion, that.resourceVersion)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(uid, that.uid)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  fieldPath,  kind,  name,  namespace,  resourceVersion,  source,  uid,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (fieldPath != null) { sb.append("fieldPath:"); sb.append(fieldPath + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (resourceVersion != null) { sb.append("resourceVersion:"); sb.append(resourceVersion + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SourceNestedImpl<N> extends ObjectReferenceFluentImpl<MachineConfigPoolStatusConfigurationFluentImpl.SourceNested<N>> implements MachineConfigPoolStatusConfigurationFluentImpl.SourceNested<N>,Nested<N>{
    SourceNestedImpl(int index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    SourceNestedImpl() {
      this.index = -1;
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    int index;
    public N and() {
      return (N) MachineConfigPoolStatusConfigurationFluentImpl.this.setToSource(index,builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  
}