package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineConfigPoolStatusConfigurationBuilder extends MachineConfigPoolStatusConfigurationFluentImpl<MachineConfigPoolStatusConfigurationBuilder> implements VisitableBuilder<MachineConfigPoolStatusConfiguration,MachineConfigPoolStatusConfigurationBuilder>{
  public MachineConfigPoolStatusConfigurationBuilder() {
    this(false);
  }
  public MachineConfigPoolStatusConfigurationBuilder(Boolean validationEnabled) {
    this(new MachineConfigPoolStatusConfiguration(), validationEnabled);
  }
  public MachineConfigPoolStatusConfigurationBuilder(MachineConfigPoolStatusConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineConfigPoolStatusConfigurationBuilder(MachineConfigPoolStatusConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineConfigPoolStatusConfiguration(), validationEnabled);
  }
  public MachineConfigPoolStatusConfigurationBuilder(MachineConfigPoolStatusConfigurationFluent<?> fluent,MachineConfigPoolStatusConfiguration instance) {
    this(fluent, instance, false);
  }
  public MachineConfigPoolStatusConfigurationBuilder(MachineConfigPoolStatusConfigurationFluent<?> fluent,MachineConfigPoolStatusConfiguration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withFieldPath(instance.getFieldPath());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResourceVersion(instance.getResourceVersion());
      fluent.withSource(instance.getSource());
      fluent.withUid(instance.getUid());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineConfigPoolStatusConfigurationBuilder(MachineConfigPoolStatusConfiguration instance) {
    this(instance,false);
  }
  public MachineConfigPoolStatusConfigurationBuilder(MachineConfigPoolStatusConfiguration instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withFieldPath(instance.getFieldPath());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResourceVersion(instance.getResourceVersion());
      this.withSource(instance.getSource());
      this.withUid(instance.getUid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineConfigPoolStatusConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public MachineConfigPoolStatusConfiguration build() {
    MachineConfigPoolStatusConfiguration buildable = new MachineConfigPoolStatusConfiguration(fluent.getApiVersion(),fluent.getFieldPath(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getResourceVersion(),fluent.getSource(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}