package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineConfigPoolSpecBuilder extends MachineConfigPoolSpecFluentImpl<MachineConfigPoolSpecBuilder> implements VisitableBuilder<MachineConfigPoolSpec,MachineConfigPoolSpecBuilder>{
  public MachineConfigPoolSpecBuilder() {
    this(false);
  }
  public MachineConfigPoolSpecBuilder(Boolean validationEnabled) {
    this(new MachineConfigPoolSpec(), validationEnabled);
  }
  public MachineConfigPoolSpecBuilder(MachineConfigPoolSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineConfigPoolSpecBuilder(MachineConfigPoolSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineConfigPoolSpec(), validationEnabled);
  }
  public MachineConfigPoolSpecBuilder(MachineConfigPoolSpecFluent<?> fluent,MachineConfigPoolSpec instance) {
    this(fluent, instance, false);
  }
  public MachineConfigPoolSpecBuilder(MachineConfigPoolSpecFluent<?> fluent,MachineConfigPoolSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfiguration(instance.getConfiguration());
      fluent.withMachineConfigSelector(instance.getMachineConfigSelector());
      fluent.withMaxUnavailable(instance.getMaxUnavailable());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withPaused(instance.getPaused());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineConfigPoolSpecBuilder(MachineConfigPoolSpec instance) {
    this(instance,false);
  }
  public MachineConfigPoolSpecBuilder(MachineConfigPoolSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfiguration(instance.getConfiguration());
      this.withMachineConfigSelector(instance.getMachineConfigSelector());
      this.withMaxUnavailable(instance.getMaxUnavailable());
      this.withNodeSelector(instance.getNodeSelector());
      this.withPaused(instance.getPaused());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineConfigPoolSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MachineConfigPoolSpec build() {
    MachineConfigPoolSpec buildable = new MachineConfigPoolSpec(fluent.getConfiguration(),fluent.getMachineConfigSelector(),fluent.getMaxUnavailable(),fluent.getNodeSelector(),fluent.getPaused());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}