package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineConfigPoolListBuilder extends MachineConfigPoolListFluentImpl<MachineConfigPoolListBuilder> implements VisitableBuilder<MachineConfigPoolList,MachineConfigPoolListBuilder>{
  public MachineConfigPoolListBuilder() {
    this(false);
  }
  public MachineConfigPoolListBuilder(Boolean validationEnabled) {
    this(new MachineConfigPoolList(), validationEnabled);
  }
  public MachineConfigPoolListBuilder(MachineConfigPoolListFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineConfigPoolListBuilder(MachineConfigPoolListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineConfigPoolList(), validationEnabled);
  }
  public MachineConfigPoolListBuilder(MachineConfigPoolListFluent<?> fluent,MachineConfigPoolList instance) {
    this(fluent, instance, false);
  }
  public MachineConfigPoolListBuilder(MachineConfigPoolListFluent<?> fluent,MachineConfigPoolList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineConfigPoolListBuilder(MachineConfigPoolList instance) {
    this(instance,false);
  }
  public MachineConfigPoolListBuilder(MachineConfigPoolList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineConfigPoolListFluent<?> fluent;
  Boolean validationEnabled;
  public MachineConfigPoolList build() {
    MachineConfigPoolList buildable = new MachineConfigPoolList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}