package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface MachineConfigFluent<A extends MachineConfigFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public MachineConfigFluent.MetadataNested<A> withNewMetadata();
  public MachineConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public MachineConfigFluent.MetadataNested<A> editMetadata();
  public MachineConfigFluent.MetadataNested<A> editOrNewMetadata();
  public MachineConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachineConfigSpec getSpec();
  public MachineConfigSpec buildSpec();
  public A withSpec(MachineConfigSpec spec);
  public Boolean hasSpec();
  public MachineConfigFluent.SpecNested<A> withNewSpec();
  public MachineConfigFluent.SpecNested<A> withNewSpecLike(MachineConfigSpec item);
  public MachineConfigFluent.SpecNested<A> editSpec();
  public MachineConfigFluent.SpecNested<A> editOrNewSpec();
  public MachineConfigFluent.SpecNested<A> editOrNewSpecLike(MachineConfigSpec item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MachineConfigFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,MachineConfigSpecFluent<MachineConfigFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  
}