package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineConfigBuilder extends MachineConfigFluentImpl<MachineConfigBuilder> implements VisitableBuilder<MachineConfig,MachineConfigBuilder>{
  public MachineConfigBuilder() {
    this(false);
  }
  public MachineConfigBuilder(Boolean validationEnabled) {
    this(new MachineConfig(), validationEnabled);
  }
  public MachineConfigBuilder(MachineConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineConfigBuilder(MachineConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineConfig(), validationEnabled);
  }
  public MachineConfigBuilder(MachineConfigFluent<?> fluent,MachineConfig instance) {
    this(fluent, instance, false);
  }
  public MachineConfigBuilder(MachineConfigFluent<?> fluent,MachineConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineConfigBuilder(MachineConfig instance) {
    this(instance,false);
  }
  public MachineConfigBuilder(MachineConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineConfigFluent<?> fluent;
  Boolean validationEnabled;
  public MachineConfig build() {
    MachineConfig buildable = new MachineConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}