package io.fabric8.openshift.api.model.machineconfig.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfile;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface KubeletConfigSpecFluent<A extends KubeletConfigSpecFluent<A>> extends Fluent<A>{
  public Boolean getAutoSizingReserved();
  public A withAutoSizingReserved(Boolean autoSizingReserved);
  public Boolean hasAutoSizingReserved();
  public A addToKubeletConfig(String key,Object value);
  public A addToKubeletConfig(Map<String,Object> map);
  public A removeFromKubeletConfig(String key);
  public A removeFromKubeletConfig(Map<String,Object> map);
  public Map<String,Object> getKubeletConfig();
  public <K,V>A withKubeletConfig(Map<String,Object> kubeletConfig);
  public Boolean hasKubeletConfig();
  public Integer getLogLevel();
  public A withLogLevel(Integer logLevel);
  public Boolean hasLogLevel();
  
  /**
   * This method has been deprecated, please use method buildMachineConfigPoolSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getMachineConfigPoolSelector();
  public LabelSelector buildMachineConfigPoolSelector();
  public A withMachineConfigPoolSelector(LabelSelector machineConfigPoolSelector);
  public Boolean hasMachineConfigPoolSelector();
  public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelector();
  public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelectorLike(LabelSelector item);
  public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> editMachineConfigPoolSelector();
  public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelector();
  public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelectorLike(LabelSelector item);
  public TLSSecurityProfile getTlsSecurityProfile();
  public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile);
  public Boolean hasTlsSecurityProfile();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withAutoSizingReserved();
  public interface MachineConfigPoolSelectorNested<N> extends Nested<N>,LabelSelectorFluent<KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<N>>{
    public N and();
    public N endMachineConfigPoolSelector();
    
  }
  
}