package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface KubeletConfigFluent<A extends KubeletConfigFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public KubeletConfigFluent.MetadataNested<A> withNewMetadata();
  public KubeletConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public KubeletConfigFluent.MetadataNested<A> editMetadata();
  public KubeletConfigFluent.MetadataNested<A> editOrNewMetadata();
  public KubeletConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubeletConfigSpec getSpec();
  public KubeletConfigSpec buildSpec();
  public A withSpec(KubeletConfigSpec spec);
  public Boolean hasSpec();
  public KubeletConfigFluent.SpecNested<A> withNewSpec();
  public KubeletConfigFluent.SpecNested<A> withNewSpecLike(KubeletConfigSpec item);
  public KubeletConfigFluent.SpecNested<A> editSpec();
  public KubeletConfigFluent.SpecNested<A> editOrNewSpec();
  public KubeletConfigFluent.SpecNested<A> editOrNewSpecLike(KubeletConfigSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubeletConfigStatus getStatus();
  public KubeletConfigStatus buildStatus();
  public A withStatus(KubeletConfigStatus status);
  public Boolean hasStatus();
  public KubeletConfigFluent.StatusNested<A> withNewStatus();
  public KubeletConfigFluent.StatusNested<A> withNewStatusLike(KubeletConfigStatus item);
  public KubeletConfigFluent.StatusNested<A> editStatus();
  public KubeletConfigFluent.StatusNested<A> editOrNewStatus();
  public KubeletConfigFluent.StatusNested<A> editOrNewStatusLike(KubeletConfigStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<KubeletConfigFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,KubeletConfigSpecFluent<KubeletConfigFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,KubeletConfigStatusFluent<KubeletConfigFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}