package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ControllerConfigStatusFluentImpl<A extends ControllerConfigStatusFluent<A>> extends BaseFluent<A> implements ControllerConfigStatusFluent<A>{
  public ControllerConfigStatusFluentImpl() {
  }
  public ControllerConfigStatusFluentImpl(ControllerConfigStatus instance) {
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ControllerConfigStatusConditionBuilder> conditions = new ArrayList<ControllerConfigStatusConditionBuilder>();
  private Long observedGeneration;
  private Map<String,Object> additionalProperties;
  public A addToConditions(int index,ControllerConfigStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ControllerConfigStatusConditionBuilder>();}
    ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,ControllerConfigStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ControllerConfigStatusConditionBuilder>();}
    ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigStatusCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ControllerConfigStatusConditionBuilder>();}
    for (ControllerConfigStatusCondition item : items) {ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ControllerConfigStatusCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ControllerConfigStatusConditionBuilder>();}
    for (ControllerConfigStatusCondition item : items) {ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigStatusCondition... items) {
    for (ControllerConfigStatusCondition item : items) {ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ControllerConfigStatusCondition> items) {
    for (ControllerConfigStatusCondition item : items) {ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ControllerConfigStatusConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ControllerConfigStatusConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ControllerConfigStatusConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ControllerConfigStatusCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ControllerConfigStatusCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ControllerConfigStatusCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public ControllerConfigStatusCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ControllerConfigStatusCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ControllerConfigStatusCondition buildMatchingCondition(Predicate<ControllerConfigStatusConditionBuilder> predicate) {
    for (ControllerConfigStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ControllerConfigStatusConditionBuilder> predicate) {
    for (ControllerConfigStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ControllerConfigStatusCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ControllerConfigStatusCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigStatusCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ControllerConfigStatusCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ControllerConfigStatusCondition(lastTransitionTime, message, reason, status, type));
  }
  public ControllerConfigStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new ControllerConfigStatusFluentImpl.ConditionsNestedImpl();
  }
  public ControllerConfigStatusFluentImpl.ConditionsNested<A> addNewConditionLike(ControllerConfigStatusCondition item) {
    return new ControllerConfigStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ControllerConfigStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,ControllerConfigStatusCondition item) {
    return new ControllerConfigStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ControllerConfigStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ControllerConfigStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ControllerConfigStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ControllerConfigStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<ControllerConfigStatusConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ControllerConfigStatusFluentImpl that = (ControllerConfigStatusFluentImpl) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  observedGeneration,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ControllerConfigStatusConditionFluentImpl<ControllerConfigStatusFluentImpl.ConditionsNested<N>> implements ControllerConfigStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,ControllerConfigStatusCondition item) {
      this.index = index;
      this.builder = new ControllerConfigStatusConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ControllerConfigStatusConditionBuilder(this);
    }
    ControllerConfigStatusConditionBuilder builder;
    int index;
    public N and() {
      return (N) ControllerConfigStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}