package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ControllerConfigStatusBuilder extends ControllerConfigStatusFluentImpl<ControllerConfigStatusBuilder> implements VisitableBuilder<ControllerConfigStatus,ControllerConfigStatusBuilder>{
  public ControllerConfigStatusBuilder() {
    this(false);
  }
  public ControllerConfigStatusBuilder(Boolean validationEnabled) {
    this(new ControllerConfigStatus(), validationEnabled);
  }
  public ControllerConfigStatusBuilder(ControllerConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ControllerConfigStatusBuilder(ControllerConfigStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ControllerConfigStatus(), validationEnabled);
  }
  public ControllerConfigStatusBuilder(ControllerConfigStatusFluent<?> fluent,ControllerConfigStatus instance) {
    this(fluent, instance, false);
  }
  public ControllerConfigStatusBuilder(ControllerConfigStatusFluent<?> fluent,ControllerConfigStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ControllerConfigStatusBuilder(ControllerConfigStatus instance) {
    this(instance,false);
  }
  public ControllerConfigStatusBuilder(ControllerConfigStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ControllerConfigStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ControllerConfigStatus build() {
    ControllerConfigStatus buildable = new ControllerConfigStatus(fluent.getConditions(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}