package io.fabric8.openshift.api.model.machineconfig.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.DNS;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.config.v1.ProxyStatus;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.Infrastructure;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ControllerConfigSpecFluentImpl<A extends ControllerConfigSpecFluent<A>> extends BaseFluent<A> implements ControllerConfigSpecFluent<A>{
  public ControllerConfigSpecFluentImpl() {
  }
  public ControllerConfigSpecFluentImpl(ControllerConfigSpec instance) {
    if (instance != null) {
      this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle());
      this.withCloudProviderCAData(instance.getCloudProviderCAData());
      this.withCloudProviderConfig(instance.getCloudProviderConfig());
      this.withClusterDNSIP(instance.getClusterDNSIP());
      this.withDns(instance.getDns());
      this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
      this.withImages(instance.getImages());
      this.withInfra(instance.getInfra());
      this.withIpFamilies(instance.getIpFamilies());
      this.withKubeAPIServerServingCAData(instance.getKubeAPIServerServingCAData());
      this.withNetworkType(instance.getNetworkType());
      this.withOsImageURL(instance.getOsImageURL());
      this.withPlatform(instance.getPlatform());
      this.withProxy(instance.getProxy());
      this.withPullSecret(instance.getPullSecret());
      this.withReleaseImage(instance.getReleaseImage());
      this.withRootCAData(instance.getRootCAData());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String additionalTrustBundle;
  private String cloudProviderCAData;
  private String cloudProviderConfig;
  private String clusterDNSIP;
  private DNS dns;
  private String etcdDiscoveryDomain;
  private Map<String,String> images;
  private Infrastructure infra;
  private String ipFamilies;
  private String kubeAPIServerServingCAData;
  private String networkType;
  private String osImageURL;
  private String platform;
  private ProxyStatus proxy;
  private ObjectReferenceBuilder pullSecret;
  private String releaseImage;
  private String rootCAData;
  private Map<String,Object> additionalProperties;
  public String getAdditionalTrustBundle() {
    return this.additionalTrustBundle;
  }
  public A withAdditionalTrustBundle(String additionalTrustBundle) {
    this.additionalTrustBundle=additionalTrustBundle; return (A) this;
  }
  public Boolean hasAdditionalTrustBundle() {
    return this.additionalTrustBundle != null;
  }
  public String getCloudProviderCAData() {
    return this.cloudProviderCAData;
  }
  public A withCloudProviderCAData(String cloudProviderCAData) {
    this.cloudProviderCAData=cloudProviderCAData; return (A) this;
  }
  public Boolean hasCloudProviderCAData() {
    return this.cloudProviderCAData != null;
  }
  public String getCloudProviderConfig() {
    return this.cloudProviderConfig;
  }
  public A withCloudProviderConfig(String cloudProviderConfig) {
    this.cloudProviderConfig=cloudProviderConfig; return (A) this;
  }
  public Boolean hasCloudProviderConfig() {
    return this.cloudProviderConfig != null;
  }
  public String getClusterDNSIP() {
    return this.clusterDNSIP;
  }
  public A withClusterDNSIP(String clusterDNSIP) {
    this.clusterDNSIP=clusterDNSIP; return (A) this;
  }
  public Boolean hasClusterDNSIP() {
    return this.clusterDNSIP != null;
  }
  public DNS getDns() {
    return this.dns;
  }
  public A withDns(DNS dns) {
    this.dns=dns; return (A) this;
  }
  public Boolean hasDns() {
    return this.dns != null;
  }
  public String getEtcdDiscoveryDomain() {
    return this.etcdDiscoveryDomain;
  }
  public A withEtcdDiscoveryDomain(String etcdDiscoveryDomain) {
    this.etcdDiscoveryDomain=etcdDiscoveryDomain; return (A) this;
  }
  public Boolean hasEtcdDiscoveryDomain() {
    return this.etcdDiscoveryDomain != null;
  }
  public A addToImages(String key,String value) {
    if(this.images == null && key != null && value != null) { this.images = new LinkedHashMap(); }
    if(key != null && value != null) {this.images.put(key, value);} return (A)this;
  }
  public A addToImages(Map<String,String> map) {
    if(this.images == null && map != null) { this.images = new LinkedHashMap(); }
    if(map != null) { this.images.putAll(map);} return (A)this;
  }
  public A removeFromImages(String key) {
    if(this.images == null) { return (A) this; }
    if(key != null && this.images != null) {this.images.remove(key);} return (A)this;
  }
  public A removeFromImages(Map<String,String> map) {
    if(this.images == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.images != null){this.images.remove(key);}}} return (A)this;
  }
  public Map<String,String> getImages() {
    return this.images;
  }
  public <K,V>A withImages(Map<String,String> images) {
    if (images == null) { this.images =  null;} else {this.images = new LinkedHashMap(images);} return (A) this;
  }
  public Boolean hasImages() {
    return this.images != null;
  }
  public Infrastructure getInfra() {
    return this.infra;
  }
  public A withInfra(Infrastructure infra) {
    this.infra=infra; return (A) this;
  }
  public Boolean hasInfra() {
    return this.infra != null;
  }
  public String getIpFamilies() {
    return this.ipFamilies;
  }
  public A withIpFamilies(String ipFamilies) {
    this.ipFamilies=ipFamilies; return (A) this;
  }
  public Boolean hasIpFamilies() {
    return this.ipFamilies != null;
  }
  public String getKubeAPIServerServingCAData() {
    return this.kubeAPIServerServingCAData;
  }
  public A withKubeAPIServerServingCAData(String kubeAPIServerServingCAData) {
    this.kubeAPIServerServingCAData=kubeAPIServerServingCAData; return (A) this;
  }
  public Boolean hasKubeAPIServerServingCAData() {
    return this.kubeAPIServerServingCAData != null;
  }
  public String getNetworkType() {
    return this.networkType;
  }
  public A withNetworkType(String networkType) {
    this.networkType=networkType; return (A) this;
  }
  public Boolean hasNetworkType() {
    return this.networkType != null;
  }
  public String getOsImageURL() {
    return this.osImageURL;
  }
  public A withOsImageURL(String osImageURL) {
    this.osImageURL=osImageURL; return (A) this;
  }
  public Boolean hasOsImageURL() {
    return this.osImageURL != null;
  }
  public String getPlatform() {
    return this.platform;
  }
  public A withPlatform(String platform) {
    this.platform=platform; return (A) this;
  }
  public Boolean hasPlatform() {
    return this.platform != null;
  }
  public ProxyStatus getProxy() {
    return this.proxy;
  }
  public A withProxy(ProxyStatus proxy) {
    this.proxy=proxy; return (A) this;
  }
  public Boolean hasProxy() {
    return this.proxy != null;
  }
  public A withNewProxy(String httpProxy,String httpsProxy,String noProxy) {
    return (A)withProxy(new ProxyStatus(httpProxy, httpsProxy, noProxy));
  }
  
  /**
   * This method has been deprecated, please use method buildPullSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getPullSecret() {
    return this.pullSecret!=null ?this.pullSecret.build():null;
  }
  public ObjectReference buildPullSecret() {
    return this.pullSecret!=null ?this.pullSecret.build():null;
  }
  public A withPullSecret(ObjectReference pullSecret) {
    _visitables.get("pullSecret").remove(this.pullSecret);
    if (pullSecret!=null){ this.pullSecret= new ObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} else { this.pullSecret = null; _visitables.get("pullSecret").remove(this.pullSecret); } return (A) this;
  }
  public Boolean hasPullSecret() {
    return this.pullSecret != null;
  }
  public ControllerConfigSpecFluentImpl.PullSecretNested<A> withNewPullSecret() {
    return new ControllerConfigSpecFluentImpl.PullSecretNestedImpl();
  }
  public ControllerConfigSpecFluentImpl.PullSecretNested<A> withNewPullSecretLike(ObjectReference item) {
    return new ControllerConfigSpecFluentImpl.PullSecretNestedImpl(item);
  }
  public ControllerConfigSpecFluentImpl.PullSecretNested<A> editPullSecret() {
    return withNewPullSecretLike(getPullSecret());
  }
  public ControllerConfigSpecFluentImpl.PullSecretNested<A> editOrNewPullSecret() {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new ObjectReferenceBuilder().build());
  }
  public ControllerConfigSpecFluentImpl.PullSecretNested<A> editOrNewPullSecretLike(ObjectReference item) {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
  }
  public String getReleaseImage() {
    return this.releaseImage;
  }
  public A withReleaseImage(String releaseImage) {
    this.releaseImage=releaseImage; return (A) this;
  }
  public Boolean hasReleaseImage() {
    return this.releaseImage != null;
  }
  public String getRootCAData() {
    return this.rootCAData;
  }
  public A withRootCAData(String rootCAData) {
    this.rootCAData=rootCAData; return (A) this;
  }
  public Boolean hasRootCAData() {
    return this.rootCAData != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ControllerConfigSpecFluentImpl that = (ControllerConfigSpecFluentImpl) o;
    if (!java.util.Objects.equals(additionalTrustBundle, that.additionalTrustBundle)) return false;

    if (!java.util.Objects.equals(cloudProviderCAData, that.cloudProviderCAData)) return false;

    if (!java.util.Objects.equals(cloudProviderConfig, that.cloudProviderConfig)) return false;

    if (!java.util.Objects.equals(clusterDNSIP, that.clusterDNSIP)) return false;

    if (!java.util.Objects.equals(dns, that.dns)) return false;

    if (!java.util.Objects.equals(etcdDiscoveryDomain, that.etcdDiscoveryDomain)) return false;

    if (!java.util.Objects.equals(images, that.images)) return false;

    if (!java.util.Objects.equals(infra, that.infra)) return false;

    if (!java.util.Objects.equals(ipFamilies, that.ipFamilies)) return false;

    if (!java.util.Objects.equals(kubeAPIServerServingCAData, that.kubeAPIServerServingCAData)) return false;

    if (!java.util.Objects.equals(networkType, that.networkType)) return false;

    if (!java.util.Objects.equals(osImageURL, that.osImageURL)) return false;

    if (!java.util.Objects.equals(platform, that.platform)) return false;

    if (!java.util.Objects.equals(proxy, that.proxy)) return false;

    if (!java.util.Objects.equals(pullSecret, that.pullSecret)) return false;

    if (!java.util.Objects.equals(releaseImage, that.releaseImage)) return false;

    if (!java.util.Objects.equals(rootCAData, that.rootCAData)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalTrustBundle,  cloudProviderCAData,  cloudProviderConfig,  clusterDNSIP,  dns,  etcdDiscoveryDomain,  images,  infra,  ipFamilies,  kubeAPIServerServingCAData,  networkType,  osImageURL,  platform,  proxy,  pullSecret,  releaseImage,  rootCAData,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalTrustBundle != null) { sb.append("additionalTrustBundle:"); sb.append(additionalTrustBundle + ","); }
    if (cloudProviderCAData != null) { sb.append("cloudProviderCAData:"); sb.append(cloudProviderCAData + ","); }
    if (cloudProviderConfig != null) { sb.append("cloudProviderConfig:"); sb.append(cloudProviderConfig + ","); }
    if (clusterDNSIP != null) { sb.append("clusterDNSIP:"); sb.append(clusterDNSIP + ","); }
    if (dns != null) { sb.append("dns:"); sb.append(dns + ","); }
    if (etcdDiscoveryDomain != null) { sb.append("etcdDiscoveryDomain:"); sb.append(etcdDiscoveryDomain + ","); }
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (infra != null) { sb.append("infra:"); sb.append(infra + ","); }
    if (ipFamilies != null) { sb.append("ipFamilies:"); sb.append(ipFamilies + ","); }
    if (kubeAPIServerServingCAData != null) { sb.append("kubeAPIServerServingCAData:"); sb.append(kubeAPIServerServingCAData + ","); }
    if (networkType != null) { sb.append("networkType:"); sb.append(networkType + ","); }
    if (osImageURL != null) { sb.append("osImageURL:"); sb.append(osImageURL + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (proxy != null) { sb.append("proxy:"); sb.append(proxy + ","); }
    if (pullSecret != null) { sb.append("pullSecret:"); sb.append(pullSecret + ","); }
    if (releaseImage != null) { sb.append("releaseImage:"); sb.append(releaseImage + ","); }
    if (rootCAData != null) { sb.append("rootCAData:"); sb.append(rootCAData + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PullSecretNestedImpl<N> extends ObjectReferenceFluentImpl<ControllerConfigSpecFluentImpl.PullSecretNested<N>> implements ControllerConfigSpecFluentImpl.PullSecretNested<N>,Nested<N>{
    PullSecretNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    PullSecretNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) ControllerConfigSpecFluentImpl.this.withPullSecret(builder.build());
    }
    public N endPullSecret() {
      return and();
    }
    
  }
  
}