package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ControllerConfigFluent<A extends ControllerConfigFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ControllerConfigFluent.MetadataNested<A> withNewMetadata();
  public ControllerConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ControllerConfigFluent.MetadataNested<A> editMetadata();
  public ControllerConfigFluent.MetadataNested<A> editOrNewMetadata();
  public ControllerConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ControllerConfigSpec getSpec();
  public ControllerConfigSpec buildSpec();
  public A withSpec(ControllerConfigSpec spec);
  public Boolean hasSpec();
  public ControllerConfigFluent.SpecNested<A> withNewSpec();
  public ControllerConfigFluent.SpecNested<A> withNewSpecLike(ControllerConfigSpec item);
  public ControllerConfigFluent.SpecNested<A> editSpec();
  public ControllerConfigFluent.SpecNested<A> editOrNewSpec();
  public ControllerConfigFluent.SpecNested<A> editOrNewSpecLike(ControllerConfigSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ControllerConfigStatus getStatus();
  public ControllerConfigStatus buildStatus();
  public A withStatus(ControllerConfigStatus status);
  public Boolean hasStatus();
  public ControllerConfigFluent.StatusNested<A> withNewStatus();
  public ControllerConfigFluent.StatusNested<A> withNewStatusLike(ControllerConfigStatus item);
  public ControllerConfigFluent.StatusNested<A> editStatus();
  public ControllerConfigFluent.StatusNested<A> editOrNewStatus();
  public ControllerConfigFluent.StatusNested<A> editOrNewStatusLike(ControllerConfigStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ControllerConfigFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ControllerConfigSpecFluent<ControllerConfigFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ControllerConfigStatusFluent<ControllerConfigFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}