package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerRuntimeConfigStatusBuilder extends ContainerRuntimeConfigStatusFluentImpl<ContainerRuntimeConfigStatusBuilder> implements VisitableBuilder<ContainerRuntimeConfigStatus,ContainerRuntimeConfigStatusBuilder>{
  public ContainerRuntimeConfigStatusBuilder() {
    this(false);
  }
  public ContainerRuntimeConfigStatusBuilder(Boolean validationEnabled) {
    this(new ContainerRuntimeConfigStatus(), validationEnabled);
  }
  public ContainerRuntimeConfigStatusBuilder(ContainerRuntimeConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerRuntimeConfigStatusBuilder(ContainerRuntimeConfigStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerRuntimeConfigStatus(), validationEnabled);
  }
  public ContainerRuntimeConfigStatusBuilder(ContainerRuntimeConfigStatusFluent<?> fluent,ContainerRuntimeConfigStatus instance) {
    this(fluent, instance, false);
  }
  public ContainerRuntimeConfigStatusBuilder(ContainerRuntimeConfigStatusFluent<?> fluent,ContainerRuntimeConfigStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerRuntimeConfigStatusBuilder(ContainerRuntimeConfigStatus instance) {
    this(instance,false);
  }
  public ContainerRuntimeConfigStatusBuilder(ContainerRuntimeConfigStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerRuntimeConfigStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerRuntimeConfigStatus build() {
    ContainerRuntimeConfigStatus buildable = new ContainerRuntimeConfigStatus(fluent.getConditions(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}