package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerRuntimeConfigSpecBuilder extends ContainerRuntimeConfigSpecFluentImpl<ContainerRuntimeConfigSpecBuilder> implements VisitableBuilder<ContainerRuntimeConfigSpec,ContainerRuntimeConfigSpecBuilder>{
  public ContainerRuntimeConfigSpecBuilder() {
    this(false);
  }
  public ContainerRuntimeConfigSpecBuilder(Boolean validationEnabled) {
    this(new ContainerRuntimeConfigSpec(), validationEnabled);
  }
  public ContainerRuntimeConfigSpecBuilder(ContainerRuntimeConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerRuntimeConfigSpecBuilder(ContainerRuntimeConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerRuntimeConfigSpec(), validationEnabled);
  }
  public ContainerRuntimeConfigSpecBuilder(ContainerRuntimeConfigSpecFluent<?> fluent,ContainerRuntimeConfigSpec instance) {
    this(fluent, instance, false);
  }
  public ContainerRuntimeConfigSpecBuilder(ContainerRuntimeConfigSpecFluent<?> fluent,ContainerRuntimeConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withContainerRuntimeConfig(instance.getContainerRuntimeConfig());
      fluent.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerRuntimeConfigSpecBuilder(ContainerRuntimeConfigSpec instance) {
    this(instance,false);
  }
  public ContainerRuntimeConfigSpecBuilder(ContainerRuntimeConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withContainerRuntimeConfig(instance.getContainerRuntimeConfig());
      this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerRuntimeConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerRuntimeConfigSpec build() {
    ContainerRuntimeConfigSpec buildable = new ContainerRuntimeConfigSpec(fluent.getContainerRuntimeConfig(),fluent.getMachineConfigPoolSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}