package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerRuntimeConfigListBuilder extends ContainerRuntimeConfigListFluentImpl<ContainerRuntimeConfigListBuilder> implements VisitableBuilder<ContainerRuntimeConfigList,ContainerRuntimeConfigListBuilder>{
  public ContainerRuntimeConfigListBuilder() {
    this(false);
  }
  public ContainerRuntimeConfigListBuilder(Boolean validationEnabled) {
    this(new ContainerRuntimeConfigList(), validationEnabled);
  }
  public ContainerRuntimeConfigListBuilder(ContainerRuntimeConfigListFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerRuntimeConfigListBuilder(ContainerRuntimeConfigListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerRuntimeConfigList(), validationEnabled);
  }
  public ContainerRuntimeConfigListBuilder(ContainerRuntimeConfigListFluent<?> fluent,ContainerRuntimeConfigList instance) {
    this(fluent, instance, false);
  }
  public ContainerRuntimeConfigListBuilder(ContainerRuntimeConfigListFluent<?> fluent,ContainerRuntimeConfigList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerRuntimeConfigListBuilder(ContainerRuntimeConfigList instance) {
    this(instance,false);
  }
  public ContainerRuntimeConfigListBuilder(ContainerRuntimeConfigList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerRuntimeConfigListFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerRuntimeConfigList build() {
    ContainerRuntimeConfigList buildable = new ContainerRuntimeConfigList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}