package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ContainerRuntimeConfigFluent<A extends ContainerRuntimeConfigFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ContainerRuntimeConfigFluent.MetadataNested<A> withNewMetadata();
  public ContainerRuntimeConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ContainerRuntimeConfigFluent.MetadataNested<A> editMetadata();
  public ContainerRuntimeConfigFluent.MetadataNested<A> editOrNewMetadata();
  public ContainerRuntimeConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ContainerRuntimeConfigSpec getSpec();
  public ContainerRuntimeConfigSpec buildSpec();
  public A withSpec(ContainerRuntimeConfigSpec spec);
  public Boolean hasSpec();
  public ContainerRuntimeConfigFluent.SpecNested<A> withNewSpec();
  public ContainerRuntimeConfigFluent.SpecNested<A> withNewSpecLike(ContainerRuntimeConfigSpec item);
  public ContainerRuntimeConfigFluent.SpecNested<A> editSpec();
  public ContainerRuntimeConfigFluent.SpecNested<A> editOrNewSpec();
  public ContainerRuntimeConfigFluent.SpecNested<A> editOrNewSpecLike(ContainerRuntimeConfigSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ContainerRuntimeConfigStatus getStatus();
  public ContainerRuntimeConfigStatus buildStatus();
  public A withStatus(ContainerRuntimeConfigStatus status);
  public Boolean hasStatus();
  public ContainerRuntimeConfigFluent.StatusNested<A> withNewStatus();
  public ContainerRuntimeConfigFluent.StatusNested<A> withNewStatusLike(ContainerRuntimeConfigStatus item);
  public ContainerRuntimeConfigFluent.StatusNested<A> editStatus();
  public ContainerRuntimeConfigFluent.StatusNested<A> editOrNewStatus();
  public ContainerRuntimeConfigFluent.StatusNested<A> editOrNewStatusLike(ContainerRuntimeConfigStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ContainerRuntimeConfigFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ContainerRuntimeConfigSpecFluent<ContainerRuntimeConfigFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ContainerRuntimeConfigStatusFluent<ContainerRuntimeConfigFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}