package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerRuntimeConfigBuilder extends ContainerRuntimeConfigFluentImpl<ContainerRuntimeConfigBuilder> implements VisitableBuilder<ContainerRuntimeConfig,ContainerRuntimeConfigBuilder>{
  public ContainerRuntimeConfigBuilder() {
    this(false);
  }
  public ContainerRuntimeConfigBuilder(Boolean validationEnabled) {
    this(new ContainerRuntimeConfig(), validationEnabled);
  }
  public ContainerRuntimeConfigBuilder(ContainerRuntimeConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerRuntimeConfigBuilder(ContainerRuntimeConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerRuntimeConfig(), validationEnabled);
  }
  public ContainerRuntimeConfigBuilder(ContainerRuntimeConfigFluent<?> fluent,ContainerRuntimeConfig instance) {
    this(fluent, instance, false);
  }
  public ContainerRuntimeConfigBuilder(ContainerRuntimeConfigFluent<?> fluent,ContainerRuntimeConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerRuntimeConfigBuilder(ContainerRuntimeConfig instance) {
    this(instance,false);
  }
  public ContainerRuntimeConfigBuilder(ContainerRuntimeConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerRuntimeConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerRuntimeConfig build() {
    ContainerRuntimeConfig buildable = new ContainerRuntimeConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}