package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineConfigPoolStatusBuilder extends MachineConfigPoolStatusFluentImpl<MachineConfigPoolStatusBuilder> implements VisitableBuilder<MachineConfigPoolStatus,MachineConfigPoolStatusBuilder>{
  public MachineConfigPoolStatusBuilder() {
    this(false);
  }
  public MachineConfigPoolStatusBuilder(Boolean validationEnabled) {
    this(new MachineConfigPoolStatus(), validationEnabled);
  }
  public MachineConfigPoolStatusBuilder(MachineConfigPoolStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineConfigPoolStatusBuilder(MachineConfigPoolStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineConfigPoolStatus(), validationEnabled);
  }
  public MachineConfigPoolStatusBuilder(MachineConfigPoolStatusFluent<?> fluent,MachineConfigPoolStatus instance) {
    this(fluent, instance, false);
  }
  public MachineConfigPoolStatusBuilder(MachineConfigPoolStatusFluent<?> fluent,MachineConfigPoolStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withConfiguration(instance.getConfiguration()); 
    fluent.withDegradedMachineCount(instance.getDegradedMachineCount()); 
    fluent.withMachineCount(instance.getMachineCount()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReadyMachineCount(instance.getReadyMachineCount()); 
    fluent.withUnavailableMachineCount(instance.getUnavailableMachineCount()); 
    fluent.withUpdatedMachineCount(instance.getUpdatedMachineCount()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachineConfigPoolStatusBuilder(MachineConfigPoolStatus instance) {
    this(instance,false);
  }
  public MachineConfigPoolStatusBuilder(MachineConfigPoolStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withConfiguration(instance.getConfiguration()); 
    this.withDegradedMachineCount(instance.getDegradedMachineCount()); 
    this.withMachineCount(instance.getMachineCount()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyMachineCount(instance.getReadyMachineCount()); 
    this.withUnavailableMachineCount(instance.getUnavailableMachineCount()); 
    this.withUpdatedMachineCount(instance.getUpdatedMachineCount()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachineConfigPoolStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MachineConfigPoolStatus build() {
    MachineConfigPoolStatus buildable = new MachineConfigPoolStatus(fluent.getConditions(),fluent.getConfiguration(),fluent.getDegradedMachineCount(),fluent.getMachineCount(),fluent.getObservedGeneration(),fluent.getReadyMachineCount(),fluent.getUnavailableMachineCount(),fluent.getUpdatedMachineCount());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}