package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineConfigBuilder extends MachineConfigFluent<MachineConfigBuilder> implements VisitableBuilder<MachineConfig,MachineConfigBuilder>{
  public MachineConfigBuilder() {
    this(new MachineConfig());
  }
  
  public MachineConfigBuilder(MachineConfigFluent<?> fluent) {
    this(fluent, new MachineConfig());
  }
  
  public MachineConfigBuilder(MachineConfigFluent<?> fluent,MachineConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineConfigBuilder(MachineConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineConfigFluent<?> fluent;
  
  public MachineConfig build() {
    MachineConfig buildable = new MachineConfig(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}