package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ControllerConfigStatusFluent<A extends ControllerConfigStatusFluent<A>> extends BaseFluent<A>{
  public ControllerConfigStatusFluent() {
  }
  
  public ControllerConfigStatusFluent(ControllerConfigStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ControllerConfigStatusConditionBuilder> conditions = new ArrayList<ControllerConfigStatusConditionBuilder>();
  private ArrayList<ControllerCertificateBuilder> controllerCertificates = new ArrayList<ControllerCertificateBuilder>();
  private Long observedGeneration;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ControllerConfigStatus instance) {
    instance = (instance != null ? instance : new ControllerConfigStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withControllerCertificates(instance.getControllerCertificates());
          this.withObservedGeneration(instance.getObservedGeneration());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConditions(int index,ControllerConfigStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ControllerConfigStatusConditionBuilder>();}
    ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,ControllerConfigStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ControllerConfigStatusConditionBuilder>();}
    ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigStatusCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ControllerConfigStatusConditionBuilder>();}
    for (ControllerConfigStatusCondition item : items) {ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<ControllerConfigStatusCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ControllerConfigStatusConditionBuilder>();}
    for (ControllerConfigStatusCondition item : items) {ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigStatusCondition... items) {
    if (this.conditions == null) return (A)this;
    for (ControllerConfigStatusCondition item : items) {ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<ControllerConfigStatusCondition> items) {
    if (this.conditions == null) return (A)this;
    for (ControllerConfigStatusCondition item : items) {ControllerConfigStatusConditionBuilder builder = new ControllerConfigStatusConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<ControllerConfigStatusConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ControllerConfigStatusConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ControllerConfigStatusConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ControllerConfigStatusCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public ControllerConfigStatusCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public ControllerConfigStatusCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public ControllerConfigStatusCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public ControllerConfigStatusCondition buildMatchingCondition(Predicate<ControllerConfigStatusConditionBuilder> predicate) {
      for (ControllerConfigStatusConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<ControllerConfigStatusConditionBuilder> predicate) {
      for (ControllerConfigStatusConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<ControllerConfigStatusCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (ControllerConfigStatusCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigStatusCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (ControllerConfigStatusCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ControllerConfigStatusCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(ControllerConfigStatusCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,ControllerConfigStatusCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<ControllerConfigStatusConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public A addToControllerCertificates(int index,ControllerCertificate item) {
    if (this.controllerCertificates == null) {this.controllerCertificates = new ArrayList<ControllerCertificateBuilder>();}
    ControllerCertificateBuilder builder = new ControllerCertificateBuilder(item);
    if (index < 0 || index >= controllerCertificates.size()) { _visitables.get("controllerCertificates").add(builder); controllerCertificates.add(builder); } else { _visitables.get("controllerCertificates").add(index, builder); controllerCertificates.add(index, builder);}
    return (A)this;
  }
  
  public A setToControllerCertificates(int index,ControllerCertificate item) {
    if (this.controllerCertificates == null) {this.controllerCertificates = new ArrayList<ControllerCertificateBuilder>();}
    ControllerCertificateBuilder builder = new ControllerCertificateBuilder(item);
    if (index < 0 || index >= controllerCertificates.size()) { _visitables.get("controllerCertificates").add(builder); controllerCertificates.add(builder); } else { _visitables.get("controllerCertificates").set(index, builder); controllerCertificates.set(index, builder);}
    return (A)this;
  }
  
  public A addToControllerCertificates(io.fabric8.openshift.api.model.machineconfig.v1.ControllerCertificate... items) {
    if (this.controllerCertificates == null) {this.controllerCertificates = new ArrayList<ControllerCertificateBuilder>();}
    for (ControllerCertificate item : items) {ControllerCertificateBuilder builder = new ControllerCertificateBuilder(item);_visitables.get("controllerCertificates").add(builder);this.controllerCertificates.add(builder);} return (A)this;
  }
  
  public A addAllToControllerCertificates(Collection<ControllerCertificate> items) {
    if (this.controllerCertificates == null) {this.controllerCertificates = new ArrayList<ControllerCertificateBuilder>();}
    for (ControllerCertificate item : items) {ControllerCertificateBuilder builder = new ControllerCertificateBuilder(item);_visitables.get("controllerCertificates").add(builder);this.controllerCertificates.add(builder);} return (A)this;
  }
  
  public A removeFromControllerCertificates(io.fabric8.openshift.api.model.machineconfig.v1.ControllerCertificate... items) {
    if (this.controllerCertificates == null) return (A)this;
    for (ControllerCertificate item : items) {ControllerCertificateBuilder builder = new ControllerCertificateBuilder(item);_visitables.get("controllerCertificates").remove(builder); this.controllerCertificates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromControllerCertificates(Collection<ControllerCertificate> items) {
    if (this.controllerCertificates == null) return (A)this;
    for (ControllerCertificate item : items) {ControllerCertificateBuilder builder = new ControllerCertificateBuilder(item);_visitables.get("controllerCertificates").remove(builder); this.controllerCertificates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromControllerCertificates(Predicate<ControllerCertificateBuilder> predicate) {
    if (controllerCertificates == null) return (A) this;
    final Iterator<ControllerCertificateBuilder> each = controllerCertificates.iterator();
    final List visitables = _visitables.get("controllerCertificates");
    while (each.hasNext()) {
      ControllerCertificateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ControllerCertificate> buildControllerCertificates() {
    return this.controllerCertificates != null ? build(controllerCertificates) : null;
  }
  
  public ControllerCertificate buildControllerCertificate(int index) {
    return this.controllerCertificates.get(index).build();
  }
  
  public ControllerCertificate buildFirstControllerCertificate() {
    return this.controllerCertificates.get(0).build();
  }
  
  public ControllerCertificate buildLastControllerCertificate() {
    return this.controllerCertificates.get(controllerCertificates.size() - 1).build();
  }
  
  public ControllerCertificate buildMatchingControllerCertificate(Predicate<ControllerCertificateBuilder> predicate) {
      for (ControllerCertificateBuilder item : controllerCertificates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingControllerCertificate(Predicate<ControllerCertificateBuilder> predicate) {
      for (ControllerCertificateBuilder item : controllerCertificates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withControllerCertificates(List<ControllerCertificate> controllerCertificates) {
    if (this.controllerCertificates != null) {
      this._visitables.get("controllerCertificates").clear();
    }
    if (controllerCertificates != null) {
        this.controllerCertificates = new ArrayList();
        for (ControllerCertificate item : controllerCertificates) {
          this.addToControllerCertificates(item);
        }
    } else {
      this.controllerCertificates = null;
    }
    return (A) this;
  }
  
  public A withControllerCertificates(io.fabric8.openshift.api.model.machineconfig.v1.ControllerCertificate... controllerCertificates) {
    if (this.controllerCertificates != null) {
        this.controllerCertificates.clear();
        _visitables.remove("controllerCertificates");
    }
    if (controllerCertificates != null) {
      for (ControllerCertificate item : controllerCertificates) {
        this.addToControllerCertificates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasControllerCertificates() {
    return this.controllerCertificates != null && !this.controllerCertificates.isEmpty();
  }
  
  public A addNewControllerCertificate(String bundleFile,String notAfter,String notBefore,String signer,String subject) {
    return (A)addToControllerCertificates(new ControllerCertificate(bundleFile, notAfter, notBefore, signer, subject));
  }
  
  public ControllerCertificatesNested<A> addNewControllerCertificate() {
    return new ControllerCertificatesNested(-1, null);
  }
  
  public ControllerCertificatesNested<A> addNewControllerCertificateLike(ControllerCertificate item) {
    return new ControllerCertificatesNested(-1, item);
  }
  
  public ControllerCertificatesNested<A> setNewControllerCertificateLike(int index,ControllerCertificate item) {
    return new ControllerCertificatesNested(index, item);
  }
  
  public ControllerCertificatesNested<A> editControllerCertificate(int index) {
    if (controllerCertificates.size() <= index) throw new RuntimeException("Can't edit controllerCertificates. Index exceeds size.");
    return setNewControllerCertificateLike(index, buildControllerCertificate(index));
  }
  
  public ControllerCertificatesNested<A> editFirstControllerCertificate() {
    if (controllerCertificates.size() == 0) throw new RuntimeException("Can't edit first controllerCertificates. The list is empty.");
    return setNewControllerCertificateLike(0, buildControllerCertificate(0));
  }
  
  public ControllerCertificatesNested<A> editLastControllerCertificate() {
    int index = controllerCertificates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last controllerCertificates. The list is empty.");
    return setNewControllerCertificateLike(index, buildControllerCertificate(index));
  }
  
  public ControllerCertificatesNested<A> editMatchingControllerCertificate(Predicate<ControllerCertificateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<controllerCertificates.size();i++) { 
    if (predicate.test(controllerCertificates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching controllerCertificates. No match found.");
    return setNewControllerCertificateLike(index, buildControllerCertificate(index));
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
    return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ControllerConfigStatusFluent that = (ControllerConfigStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(controllerCertificates, that.controllerCertificates)) return false;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  controllerCertificates,  observedGeneration,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (controllerCertificates != null && !controllerCertificates.isEmpty()) { sb.append("controllerCertificates:"); sb.append(controllerCertificates + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends ControllerConfigStatusConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,ControllerConfigStatusCondition item) {
      this.index = index;
      this.builder = new ControllerConfigStatusConditionBuilder(this, item);
    }
    ControllerConfigStatusConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) ControllerConfigStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class ControllerCertificatesNested<N> extends ControllerCertificateFluent<ControllerCertificatesNested<N>> implements Nested<N>{
    ControllerCertificatesNested(int index,ControllerCertificate item) {
      this.index = index;
      this.builder = new ControllerCertificateBuilder(this, item);
    }
    ControllerCertificateBuilder builder;
    int index;
    
    public N and() {
      return (N) ControllerConfigStatusFluent.this.setToControllerCertificates(index,builder.build());
    }
    
    public N endControllerCertificate() {
      return and();
    }
    
  
  }

}