/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.Condition;
import io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.ConditionFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.LastOperation;
import io.fabric8.openshift.api.model.machine.v1beta1.LastOperationBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.LastOperationFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineStatusFluent<A extends MachineStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<NodeAddress> addresses = new ArrayList<NodeAddress>();
    private String authoritativeAPI;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private String errorMessage;
    private String errorReason;
    private LastOperationBuilder lastOperation;
    private String lastUpdated;
    private ObjectReferenceBuilder nodeRef;
    private String phase;
    private Object providerStatus;
    private Long synchronizedGeneration;

    public MachineStatusFluent() {
    }

    public MachineStatusFluent(MachineStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToAddresses(Collection<NodeAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        for (NodeAddress item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addNewAddress(String address, String type) {
        return this.addToAddresses(new NodeAddress(address, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(NodeAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        for (NodeAddress item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(int index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        this.addresses.add(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? MachineStatusFluent.build(this.conditions) : null;
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public LastOperation buildLastOperation() {
        return this.lastOperation != null ? this.lastOperation.build() : null;
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ObjectReference buildNodeRef() {
        return this.nodeRef != null ? this.nodeRef.build() : null;
    }

    protected void copyInstance(MachineStatus instance) {
        MachineStatus machineStatus = instance = instance != null ? instance : new MachineStatus();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withAuthoritativeAPI(instance.getAuthoritativeAPI());
            this.withConditions(instance.getConditions());
            this.withErrorMessage(instance.getErrorMessage());
            this.withErrorReason(instance.getErrorReason());
            this.withLastOperation(instance.getLastOperation());
            this.withLastUpdated(instance.getLastUpdated());
            this.withNodeRef(instance.getNodeRef());
            this.withPhase(instance.getPhase());
            this.withProviderStatus(instance.getProviderStatus());
            this.withSynchronizedGeneration(instance.getSynchronizedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public LastOperationNested<A> editLastOperation() {
        return this.withNewLastOperationLike(Optional.ofNullable(this.buildLastOperation()).orElse(null));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public NodeRefNested<A> editNodeRef() {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(null));
    }

    public LastOperationNested<A> editOrNewLastOperation() {
        return this.withNewLastOperationLike(Optional.ofNullable(this.buildLastOperation()).orElse(new LastOperationBuilder().build()));
    }

    public LastOperationNested<A> editOrNewLastOperationLike(LastOperation item) {
        return this.withNewLastOperationLike(Optional.ofNullable(this.buildLastOperation()).orElse(item));
    }

    public NodeRefNested<A> editOrNewNodeRef() {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public NodeRefNested<A> editOrNewNodeRefLike(ObjectReference item) {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineStatusFluent that = (MachineStatusFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.authoritativeAPI, that.authoritativeAPI)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.errorMessage, that.errorMessage)) {
            return false;
        }
        if (!Objects.equals(this.errorReason, that.errorReason)) {
            return false;
        }
        if (!Objects.equals((Object)this.lastOperation, (Object)that.lastOperation)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdated, that.lastUpdated)) {
            return false;
        }
        if (!Objects.equals(this.nodeRef, that.nodeRef)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.providerStatus, that.providerStatus)) {
            return false;
        }
        if (!Objects.equals(this.synchronizedGeneration, that.synchronizedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public NodeAddress getAddress(int index) {
        return this.addresses.get(index);
    }

    public List<NodeAddress> getAddresses() {
        return this.addresses;
    }

    public String getAuthoritativeAPI() {
        return this.authoritativeAPI;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public NodeAddress getFirstAddress() {
        return this.addresses.get(0);
    }

    public NodeAddress getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public NodeAddress getMatchingAddress(Predicate<NodeAddress> predicate) {
        for (NodeAddress item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPhase() {
        return this.phase;
    }

    public Object getProviderStatus() {
        return this.providerStatus;
    }

    public Long getSynchronizedGeneration() {
        return this.synchronizedGeneration;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public boolean hasAuthoritativeAPI() {
        return this.authoritativeAPI != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasErrorMessage() {
        return this.errorMessage != null;
    }

    public boolean hasErrorReason() {
        return this.errorReason != null;
    }

    public boolean hasLastOperation() {
        return this.lastOperation != null;
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    public boolean hasMatchingAddress(Predicate<NodeAddress> predicate) {
        for (NodeAddress item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodeRef() {
        return this.nodeRef != null;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public boolean hasProviderStatus() {
        return this.providerStatus != null;
    }

    public boolean hasSynchronizedGeneration() {
        return this.synchronizedGeneration != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addresses, this.authoritativeAPI, this.conditions, this.errorMessage, this.errorReason, this.lastOperation, this.lastUpdated, this.nodeRef, this.phase, this.providerStatus, this.synchronizedGeneration, this.additionalProperties});
    }

    public A removeAllFromAddresses(Collection<NodeAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (NodeAddress item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(NodeAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (NodeAddress item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public A setToAddresses(int index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        this.addresses.set(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses);
            sb.append(",");
        }
        if (this.authoritativeAPI != null) {
            sb.append("authoritativeAPI:");
            sb.append(this.authoritativeAPI);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.errorMessage != null) {
            sb.append("errorMessage:");
            sb.append(this.errorMessage);
            sb.append(",");
        }
        if (this.errorReason != null) {
            sb.append("errorReason:");
            sb.append(this.errorReason);
            sb.append(",");
        }
        if (this.lastOperation != null) {
            sb.append("lastOperation:");
            sb.append((Object)this.lastOperation);
            sb.append(",");
        }
        if (this.lastUpdated != null) {
            sb.append("lastUpdated:");
            sb.append(this.lastUpdated);
            sb.append(",");
        }
        if (this.nodeRef != null) {
            sb.append("nodeRef:");
            sb.append(this.nodeRef);
            sb.append(",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase);
            sb.append(",");
        }
        if (this.providerStatus != null) {
            sb.append("providerStatus:");
            sb.append(this.providerStatus);
            sb.append(",");
        }
        if (this.synchronizedGeneration != null) {
            sb.append("synchronizedGeneration:");
            sb.append(this.synchronizedGeneration);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAddresses(List<NodeAddress> addresses) {
        if (addresses != null) {
            this.addresses = new ArrayList<NodeAddress>();
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(NodeAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public A withAuthoritativeAPI(String authoritativeAPI) {
        this.authoritativeAPI = authoritativeAPI;
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return (A)((Object)this);
    }

    public A withErrorReason(String errorReason) {
        this.errorReason = errorReason;
        return (A)((Object)this);
    }

    public A withLastOperation(LastOperation lastOperation) {
        this._visitables.remove((Object)"lastOperation");
        if (lastOperation != null) {
            this.lastOperation = new LastOperationBuilder(lastOperation);
            this._visitables.get((Object)"lastOperation").add(this.lastOperation);
        } else {
            this.lastOperation = null;
            this._visitables.get((Object)"lastOperation").remove((Object)this.lastOperation);
        }
        return (A)((Object)this);
    }

    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)((Object)this);
    }

    public LastOperationNested<A> withNewLastOperation() {
        return new LastOperationNested(null);
    }

    public A withNewLastOperation(String description, String lastUpdated, String state, String type) {
        return this.withLastOperation(new LastOperation(description, lastUpdated, state, type));
    }

    public LastOperationNested<A> withNewLastOperationLike(LastOperation item) {
        return new LastOperationNested(item);
    }

    public NodeRefNested<A> withNewNodeRef() {
        return new NodeRefNested(null);
    }

    public NodeRefNested<A> withNewNodeRefLike(ObjectReference item) {
        return new NodeRefNested(item);
    }

    public A withNodeRef(ObjectReference nodeRef) {
        this._visitables.remove((Object)"nodeRef");
        if (nodeRef != null) {
            this.nodeRef = new ObjectReferenceBuilder(nodeRef);
            this._visitables.get((Object)"nodeRef").add(this.nodeRef);
        } else {
            this.nodeRef = null;
            this._visitables.get((Object)"nodeRef").remove(this.nodeRef);
        }
        return (A)((Object)this);
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public A withProviderStatus(Object providerStatus) {
        this.providerStatus = providerStatus;
        return (A)((Object)this);
    }

    public A withSynchronizedGeneration(Long synchronizedGeneration) {
        this.synchronizedGeneration = synchronizedGeneration;
        return (A)((Object)this);
    }

    public class NodeRefNested<N>
    extends ObjectReferenceFluent<NodeRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        NodeRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.withNodeRef(this.builder.build());
        }

        public N endNodeRef() {
            return this.and();
        }
    }

    public class LastOperationNested<N>
    extends LastOperationFluent<LastOperationNested<N>>
    implements Nested<N> {
        LastOperationBuilder builder;

        LastOperationNested(LastOperation item) {
            this.builder = new LastOperationBuilder(this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.withLastOperation(this.builder.build());
        }

        public N endLastOperation() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

