/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReference;
import io.fabric8.openshift.api.model.machine.v1beta1.Filter;
import io.fabric8.openshift.api.model.machine.v1beta1.FilterBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.FilterFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AWSResourceReferenceFluent<A extends AWSResourceReferenceFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String arn;
    private ArrayList<FilterBuilder> filters = new ArrayList();
    private String id;

    public AWSResourceReferenceFluent() {
    }

    public AWSResourceReferenceFluent(AWSResourceReference instance) {
        this.copyInstance(instance);
    }

    public A addAllToFilters(Collection<Filter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)((Object)this);
    }

    public FiltersNested<A> addNewFilter() {
        return new FiltersNested(-1, null);
    }

    public FiltersNested<A> addNewFilterLike(Filter item) {
        return new FiltersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToFilters(Filter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToFilters(int index, Filter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        FilterBuilder builder = new FilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public Filter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    public List<Filter> buildFilters() {
        return this.filters != null ? AWSResourceReferenceFluent.build(this.filters) : null;
    }

    public Filter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    public Filter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    public Filter buildMatchingFilter(Predicate<FilterBuilder> predicate) {
        for (FilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(AWSResourceReference instance) {
        AWSResourceReference aWSResourceReference = instance = instance != null ? instance : new AWSResourceReference();
        if (instance != null) {
            this.withArn(instance.getArn());
            this.withFilters(instance.getFilters());
            this.withId(instance.getId());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "filters"));
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "filters"));
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    public FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "filters"));
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editMatchingFilter(Predicate<FilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "filters"));
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSResourceReferenceFluent that = (AWSResourceReferenceFluent)((Object)o);
        if (!Objects.equals(this.arn, that.arn)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getArn() {
        return this.arn;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasArn() {
        return this.arn != null;
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean hasMatchingFilter(Predicate<FilterBuilder> predicate) {
        for (FilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.arn, this.filters, this.id, this.additionalProperties);
    }

    public A removeAllFromFilters(Collection<Filter> items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").remove((Object)builder);
            this.filters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromFilters(Filter ... items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").remove((Object)builder);
            this.filters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFilters(Predicate<FilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        Iterator<FilterBuilder> each = this.filters.iterator();
        List visitables = this._visitables.get((Object)"filters");
        while (each.hasNext()) {
            FilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public FiltersNested<A> setNewFilterLike(int index, Filter item) {
        return new FiltersNested(index, item);
    }

    public A setToFilters(int index, Filter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        FilterBuilder builder = new FilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arn != null) {
            sb.append("arn:");
            sb.append(this.arn);
            sb.append(",");
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters);
            sb.append(",");
        }
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withArn(String arn) {
        this.arn = arn;
        return (A)((Object)this);
    }

    public A withFilters(List<Filter> filters) {
        if (this.filters != null) {
            this._visitables.get((Object)"filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (Filter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)((Object)this);
    }

    public A withFilters(Filter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove((Object)"filters");
        }
        if (filters != null) {
            for (Filter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)((Object)this);
    }

    public A withId(String id) {
        this.id = id;
        return (A)((Object)this);
    }

    public class FiltersNested<N>
    extends FilterFluent<FiltersNested<N>>
    implements Nested<N> {
        FilterBuilder builder;
        int index;

        FiltersNested(int index, Filter item) {
            this.index = index;
            this.builder = new FilterBuilder(this, item);
        }

        public N and() {
            return (N)AWSResourceReferenceFluent.this.setToFilters(this.index, this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }
}

