/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.openshift.api.model.machine.v1beta1.ObjectMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ObjectMetaFluent<A extends ObjectMetaFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private String generateName;
    private Map<String, String> labels;
    private String name;
    private String namespace;
    private List<OwnerReference> ownerReferences = new ArrayList<OwnerReference>();
    private Map<String, Object> additionalProperties;

    public ObjectMetaFluent() {
    }

    public ObjectMetaFluent(ObjectMeta instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ObjectMeta instance) {
        ObjectMeta objectMeta = instance = instance != null ? instance : new ObjectMeta();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withGenerateName(instance.getGenerateName());
            this.withLabels(instance.getLabels());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withOwnerReferences(instance.getOwnerReferences());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public String getGenerateName() {
        return this.generateName;
    }

    public A withGenerateName(String generateName) {
        this.generateName = generateName;
        return (A)((Object)this);
    }

    public boolean hasGenerateName() {
        return this.generateName != null;
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)((Object)this);
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public A addToOwnerReferences(int index, OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
        }
        this.ownerReferences.add(index, item);
        return (A)((Object)this);
    }

    public A setToOwnerReferences(int index, OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
        }
        this.ownerReferences.set(index, item);
        return (A)((Object)this);
    }

    public A addToOwnerReferences(OwnerReference ... items) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
        }
        for (OwnerReference item : items) {
            this.ownerReferences.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOwnerReferences(Collection<OwnerReference> items) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
        }
        for (OwnerReference item : items) {
            this.ownerReferences.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOwnerReferences(OwnerReference ... items) {
        if (this.ownerReferences == null) {
            return (A)((Object)this);
        }
        for (OwnerReference item : items) {
            this.ownerReferences.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOwnerReferences(Collection<OwnerReference> items) {
        if (this.ownerReferences == null) {
            return (A)((Object)this);
        }
        for (OwnerReference item : items) {
            this.ownerReferences.remove(item);
        }
        return (A)((Object)this);
    }

    public List<OwnerReference> getOwnerReferences() {
        return this.ownerReferences;
    }

    public OwnerReference getOwnerReference(int index) {
        return this.ownerReferences.get(index);
    }

    public OwnerReference getFirstOwnerReference() {
        return this.ownerReferences.get(0);
    }

    public OwnerReference getLastOwnerReference() {
        return this.ownerReferences.get(this.ownerReferences.size() - 1);
    }

    public OwnerReference getMatchingOwnerReference(Predicate<OwnerReference> predicate) {
        for (OwnerReference item : this.ownerReferences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOwnerReference(Predicate<OwnerReference> predicate) {
        for (OwnerReference item : this.ownerReferences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOwnerReferences(List<OwnerReference> ownerReferences) {
        if (ownerReferences != null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
            for (OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        } else {
            this.ownerReferences = null;
        }
        return (A)((Object)this);
    }

    public A withOwnerReferences(OwnerReference ... ownerReferences) {
        if (this.ownerReferences != null) {
            this.ownerReferences.clear();
            this._visitables.remove((Object)"ownerReferences");
        }
        if (ownerReferences != null) {
            for (OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOwnerReferences() {
        return this.ownerReferences != null && !this.ownerReferences.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMetaFluent that = (ObjectMetaFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.generateName, that.generateName)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.ownerReferences, that.ownerReferences)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.generateName, this.labels, this.name, this.namespace, this.ownerReferences, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(String.valueOf(this.annotations) + ",");
        }
        if (this.generateName != null) {
            sb.append("generateName:");
            sb.append(this.generateName + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(String.valueOf(this.labels) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.ownerReferences != null && !this.ownerReferences.isEmpty()) {
            sb.append("ownerReferences:");
            sb.append(String.valueOf(this.ownerReferences) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

