package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WorkspaceBuilder extends WorkspaceFluent<WorkspaceBuilder> implements VisitableBuilder<Workspace,WorkspaceBuilder>{
  public WorkspaceBuilder() {
    this(new Workspace());
  }
  
  public WorkspaceBuilder(WorkspaceFluent<?> fluent) {
    this(fluent, new Workspace());
  }
  
  public WorkspaceBuilder(WorkspaceFluent<?> fluent,Workspace instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WorkspaceBuilder(Workspace instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WorkspaceFluent<?> fluent;
  
  public Workspace build() {
    Workspace buildable = new Workspace(fluent.getDatacenter(),fluent.getDatastore(),fluent.getFolder(),fluent.getResourcePool(),fluent.getServer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}