package io.fabric8.openshift.api.model.machine.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VSphereMachineProviderSpecFluent<A extends VSphereMachineProviderSpecFluent<A>> extends BaseFluent<A>{
  public VSphereMachineProviderSpecFluent() {
  }
  
  public VSphereMachineProviderSpecFluent(VSphereMachineProviderSpec instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String cloneMode;
  private LocalObjectReferenceBuilder credentialsSecret;
  private Integer diskGiB;
  private String kind;
  private Long memoryMiB;
  private ObjectMetaBuilder metadata;
  private NetworkSpecBuilder network;
  private Integer numCPUs;
  private Integer numCoresPerSocket;
  private String snapshot;
  private List<String> tagIDs = new ArrayList<String>();
  private String template;
  private LocalObjectReferenceBuilder userDataSecret;
  private WorkspaceBuilder workspace;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VSphereMachineProviderSpec instance) {
    instance = (instance != null ? instance : new VSphereMachineProviderSpec());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withCloneMode(instance.getCloneMode());
          this.withCredentialsSecret(instance.getCredentialsSecret());
          this.withDiskGiB(instance.getDiskGiB());
          this.withKind(instance.getKind());
          this.withMemoryMiB(instance.getMemoryMiB());
          this.withMetadata(instance.getMetadata());
          this.withNetwork(instance.getNetwork());
          this.withNumCPUs(instance.getNumCPUs());
          this.withNumCoresPerSocket(instance.getNumCoresPerSocket());
          this.withSnapshot(instance.getSnapshot());
          this.withTagIDs(instance.getTagIDs());
          this.withTemplate(instance.getTemplate());
          this.withUserDataSecret(instance.getUserDataSecret());
          this.withWorkspace(instance.getWorkspace());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getCloneMode() {
    return this.cloneMode;
  }
  
  public A withCloneMode(String cloneMode) {
    this.cloneMode = cloneMode;
    return (A) this;
  }
  
  public boolean hasCloneMode() {
    return this.cloneMode != null;
  }
  
  public LocalObjectReference buildCredentialsSecret() {
    return this.credentialsSecret != null ? this.credentialsSecret.build() : null;
  }
  
  public A withCredentialsSecret(LocalObjectReference credentialsSecret) {
    this._visitables.remove("credentialsSecret");
    if (credentialsSecret != null) {
        this.credentialsSecret = new LocalObjectReferenceBuilder(credentialsSecret);
        this._visitables.get("credentialsSecret").add(this.credentialsSecret);
    } else {
        this.credentialsSecret = null;
        this._visitables.get("credentialsSecret").remove(this.credentialsSecret);
    }
    return (A) this;
  }
  
  public boolean hasCredentialsSecret() {
    return this.credentialsSecret != null;
  }
  
  public A withNewCredentialsSecret(String name) {
    return (A)withCredentialsSecret(new LocalObjectReference(name));
  }
  
  public CredentialsSecretNested<A> withNewCredentialsSecret() {
    return new CredentialsSecretNested(null);
  }
  
  public CredentialsSecretNested<A> withNewCredentialsSecretLike(LocalObjectReference item) {
    return new CredentialsSecretNested(item);
  }
  
  public CredentialsSecretNested<A> editCredentialsSecret() {
    return withNewCredentialsSecretLike(java.util.Optional.ofNullable(buildCredentialsSecret()).orElse(null));
  }
  
  public CredentialsSecretNested<A> editOrNewCredentialsSecret() {
    return withNewCredentialsSecretLike(java.util.Optional.ofNullable(buildCredentialsSecret()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public CredentialsSecretNested<A> editOrNewCredentialsSecretLike(LocalObjectReference item) {
    return withNewCredentialsSecretLike(java.util.Optional.ofNullable(buildCredentialsSecret()).orElse(item));
  }
  
  public Integer getDiskGiB() {
    return this.diskGiB;
  }
  
  public A withDiskGiB(Integer diskGiB) {
    this.diskGiB = diskGiB;
    return (A) this;
  }
  
  public boolean hasDiskGiB() {
    return this.diskGiB != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public Long getMemoryMiB() {
    return this.memoryMiB;
  }
  
  public A withMemoryMiB(Long memoryMiB) {
    this.memoryMiB = memoryMiB;
    return (A) this;
  }
  
  public boolean hasMemoryMiB() {
    return this.memoryMiB != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public NetworkSpec buildNetwork() {
    return this.network != null ? this.network.build() : null;
  }
  
  public A withNetwork(NetworkSpec network) {
    this._visitables.remove("network");
    if (network != null) {
        this.network = new NetworkSpecBuilder(network);
        this._visitables.get("network").add(this.network);
    } else {
        this.network = null;
        this._visitables.get("network").remove(this.network);
    }
    return (A) this;
  }
  
  public boolean hasNetwork() {
    return this.network != null;
  }
  
  public NetworkNested<A> withNewNetwork() {
    return new NetworkNested(null);
  }
  
  public NetworkNested<A> withNewNetworkLike(NetworkSpec item) {
    return new NetworkNested(item);
  }
  
  public NetworkNested<A> editNetwork() {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(null));
  }
  
  public NetworkNested<A> editOrNewNetwork() {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(new NetworkSpecBuilder().build()));
  }
  
  public NetworkNested<A> editOrNewNetworkLike(NetworkSpec item) {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(item));
  }
  
  public Integer getNumCPUs() {
    return this.numCPUs;
  }
  
  public A withNumCPUs(Integer numCPUs) {
    this.numCPUs = numCPUs;
    return (A) this;
  }
  
  public boolean hasNumCPUs() {
    return this.numCPUs != null;
  }
  
  public Integer getNumCoresPerSocket() {
    return this.numCoresPerSocket;
  }
  
  public A withNumCoresPerSocket(Integer numCoresPerSocket) {
    this.numCoresPerSocket = numCoresPerSocket;
    return (A) this;
  }
  
  public boolean hasNumCoresPerSocket() {
    return this.numCoresPerSocket != null;
  }
  
  public String getSnapshot() {
    return this.snapshot;
  }
  
  public A withSnapshot(String snapshot) {
    this.snapshot = snapshot;
    return (A) this;
  }
  
  public boolean hasSnapshot() {
    return this.snapshot != null;
  }
  
  public A addToTagIDs(int index,String item) {
    if (this.tagIDs == null) {this.tagIDs = new ArrayList<String>();}
    this.tagIDs.add(index, item);
    return (A)this;
  }
  
  public A setToTagIDs(int index,String item) {
    if (this.tagIDs == null) {this.tagIDs = new ArrayList<String>();}
    this.tagIDs.set(index, item); return (A)this;
  }
  
  public A addToTagIDs(java.lang.String... items) {
    if (this.tagIDs == null) {this.tagIDs = new ArrayList<String>();}
    for (String item : items) {this.tagIDs.add(item);} return (A)this;
  }
  
  public A addAllToTagIDs(Collection<String> items) {
    if (this.tagIDs == null) {this.tagIDs = new ArrayList<String>();}
    for (String item : items) {this.tagIDs.add(item);} return (A)this;
  }
  
  public A removeFromTagIDs(java.lang.String... items) {
    if (this.tagIDs == null) return (A)this;
    for (String item : items) { this.tagIDs.remove(item);} return (A)this;
  }
  
  public A removeAllFromTagIDs(Collection<String> items) {
    if (this.tagIDs == null) return (A)this;
    for (String item : items) { this.tagIDs.remove(item);} return (A)this;
  }
  
  public List<String> getTagIDs() {
    return this.tagIDs;
  }
  
  public String getTagID(int index) {
    return this.tagIDs.get(index);
  }
  
  public String getFirstTagID() {
    return this.tagIDs.get(0);
  }
  
  public String getLastTagID() {
    return this.tagIDs.get(tagIDs.size() - 1);
  }
  
  public String getMatchingTagID(Predicate<String> predicate) {
      for (String item : tagIDs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingTagID(Predicate<String> predicate) {
      for (String item : tagIDs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTagIDs(List<String> tagIDs) {
    if (tagIDs != null) {
        this.tagIDs = new ArrayList();
        for (String item : tagIDs) {
          this.addToTagIDs(item);
        }
    } else {
      this.tagIDs = null;
    }
    return (A) this;
  }
  
  public A withTagIDs(java.lang.String... tagIDs) {
    if (this.tagIDs != null) {
        this.tagIDs.clear();
        _visitables.remove("tagIDs");
    }
    if (tagIDs != null) {
      for (String item : tagIDs) {
        this.addToTagIDs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTagIDs() {
    return this.tagIDs != null && !this.tagIDs.isEmpty();
  }
  
  public String getTemplate() {
    return this.template;
  }
  
  public A withTemplate(String template) {
    this.template = template;
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public LocalObjectReference buildUserDataSecret() {
    return this.userDataSecret != null ? this.userDataSecret.build() : null;
  }
  
  public A withUserDataSecret(LocalObjectReference userDataSecret) {
    this._visitables.remove("userDataSecret");
    if (userDataSecret != null) {
        this.userDataSecret = new LocalObjectReferenceBuilder(userDataSecret);
        this._visitables.get("userDataSecret").add(this.userDataSecret);
    } else {
        this.userDataSecret = null;
        this._visitables.get("userDataSecret").remove(this.userDataSecret);
    }
    return (A) this;
  }
  
  public boolean hasUserDataSecret() {
    return this.userDataSecret != null;
  }
  
  public A withNewUserDataSecret(String name) {
    return (A)withUserDataSecret(new LocalObjectReference(name));
  }
  
  public UserDataSecretNested<A> withNewUserDataSecret() {
    return new UserDataSecretNested(null);
  }
  
  public UserDataSecretNested<A> withNewUserDataSecretLike(LocalObjectReference item) {
    return new UserDataSecretNested(item);
  }
  
  public UserDataSecretNested<A> editUserDataSecret() {
    return withNewUserDataSecretLike(java.util.Optional.ofNullable(buildUserDataSecret()).orElse(null));
  }
  
  public UserDataSecretNested<A> editOrNewUserDataSecret() {
    return withNewUserDataSecretLike(java.util.Optional.ofNullable(buildUserDataSecret()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public UserDataSecretNested<A> editOrNewUserDataSecretLike(LocalObjectReference item) {
    return withNewUserDataSecretLike(java.util.Optional.ofNullable(buildUserDataSecret()).orElse(item));
  }
  
  public Workspace buildWorkspace() {
    return this.workspace != null ? this.workspace.build() : null;
  }
  
  public A withWorkspace(Workspace workspace) {
    this._visitables.remove("workspace");
    if (workspace != null) {
        this.workspace = new WorkspaceBuilder(workspace);
        this._visitables.get("workspace").add(this.workspace);
    } else {
        this.workspace = null;
        this._visitables.get("workspace").remove(this.workspace);
    }
    return (A) this;
  }
  
  public boolean hasWorkspace() {
    return this.workspace != null;
  }
  
  public A withNewWorkspace(String datacenter,String datastore,String folder,String resourcePool,String server) {
    return (A)withWorkspace(new Workspace(datacenter, datastore, folder, resourcePool, server));
  }
  
  public WorkspaceNested<A> withNewWorkspace() {
    return new WorkspaceNested(null);
  }
  
  public WorkspaceNested<A> withNewWorkspaceLike(Workspace item) {
    return new WorkspaceNested(item);
  }
  
  public WorkspaceNested<A> editWorkspace() {
    return withNewWorkspaceLike(java.util.Optional.ofNullable(buildWorkspace()).orElse(null));
  }
  
  public WorkspaceNested<A> editOrNewWorkspace() {
    return withNewWorkspaceLike(java.util.Optional.ofNullable(buildWorkspace()).orElse(new WorkspaceBuilder().build()));
  }
  
  public WorkspaceNested<A> editOrNewWorkspaceLike(Workspace item) {
    return withNewWorkspaceLike(java.util.Optional.ofNullable(buildWorkspace()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VSphereMachineProviderSpecFluent that = (VSphereMachineProviderSpecFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(cloneMode, that.cloneMode)) return false;
    if (!java.util.Objects.equals(credentialsSecret, that.credentialsSecret)) return false;
    if (!java.util.Objects.equals(diskGiB, that.diskGiB)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(memoryMiB, that.memoryMiB)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(network, that.network)) return false;
    if (!java.util.Objects.equals(numCPUs, that.numCPUs)) return false;
    if (!java.util.Objects.equals(numCoresPerSocket, that.numCoresPerSocket)) return false;
    if (!java.util.Objects.equals(snapshot, that.snapshot)) return false;
    if (!java.util.Objects.equals(tagIDs, that.tagIDs)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    if (!java.util.Objects.equals(userDataSecret, that.userDataSecret)) return false;
    if (!java.util.Objects.equals(workspace, that.workspace)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  cloneMode,  credentialsSecret,  diskGiB,  kind,  memoryMiB,  metadata,  network,  numCPUs,  numCoresPerSocket,  snapshot,  tagIDs,  template,  userDataSecret,  workspace,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (cloneMode != null) { sb.append("cloneMode:"); sb.append(cloneMode + ","); }
    if (credentialsSecret != null) { sb.append("credentialsSecret:"); sb.append(credentialsSecret + ","); }
    if (diskGiB != null) { sb.append("diskGiB:"); sb.append(diskGiB + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (memoryMiB != null) { sb.append("memoryMiB:"); sb.append(memoryMiB + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (numCPUs != null) { sb.append("numCPUs:"); sb.append(numCPUs + ","); }
    if (numCoresPerSocket != null) { sb.append("numCoresPerSocket:"); sb.append(numCoresPerSocket + ","); }
    if (snapshot != null) { sb.append("snapshot:"); sb.append(snapshot + ","); }
    if (tagIDs != null && !tagIDs.isEmpty()) { sb.append("tagIDs:"); sb.append(tagIDs + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (userDataSecret != null) { sb.append("userDataSecret:"); sb.append(userDataSecret + ","); }
    if (workspace != null) { sb.append("workspace:"); sb.append(workspace + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CredentialsSecretNested<N> extends LocalObjectReferenceFluent<CredentialsSecretNested<N>> implements Nested<N>{
    CredentialsSecretNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) VSphereMachineProviderSpecFluent.this.withCredentialsSecret(builder.build());
    }
    
    public N endCredentialsSecret() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) VSphereMachineProviderSpecFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class NetworkNested<N> extends NetworkSpecFluent<NetworkNested<N>> implements Nested<N>{
    NetworkNested(NetworkSpec item) {
      this.builder = new NetworkSpecBuilder(this, item);
    }
    NetworkSpecBuilder builder;
    
    public N and() {
      return (N) VSphereMachineProviderSpecFluent.this.withNetwork(builder.build());
    }
    
    public N endNetwork() {
      return and();
    }
    
  
  }
  public class UserDataSecretNested<N> extends LocalObjectReferenceFluent<UserDataSecretNested<N>> implements Nested<N>{
    UserDataSecretNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) VSphereMachineProviderSpecFluent.this.withUserDataSecret(builder.build());
    }
    
    public N endUserDataSecret() {
      return and();
    }
    
  
  }
  public class WorkspaceNested<N> extends WorkspaceFluent<WorkspaceNested<N>> implements Nested<N>{
    WorkspaceNested(Workspace item) {
      this.builder = new WorkspaceBuilder(this, item);
    }
    WorkspaceBuilder builder;
    
    public N and() {
      return (N) VSphereMachineProviderSpecFluent.this.withWorkspace(builder.build());
    }
    
    public N endWorkspace() {
      return and();
    }
    
  
  }

}