package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GCPServiceAccountBuilder extends GCPServiceAccountFluent<GCPServiceAccountBuilder> implements VisitableBuilder<GCPServiceAccount,GCPServiceAccountBuilder>{
  public GCPServiceAccountBuilder() {
    this(new GCPServiceAccount());
  }
  
  public GCPServiceAccountBuilder(GCPServiceAccountFluent<?> fluent) {
    this(fluent, new GCPServiceAccount());
  }
  
  public GCPServiceAccountBuilder(GCPServiceAccountFluent<?> fluent,GCPServiceAccount instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GCPServiceAccountBuilder(GCPServiceAccount instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GCPServiceAccountFluent<?> fluent;
  
  public GCPServiceAccount build() {
    GCPServiceAccount buildable = new GCPServiceAccount(fluent.getEmail(),fluent.getScopes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}