package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.Integer;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AWSMachineProviderConfigFluent<A extends AWSMachineProviderConfigFluent<A>> extends BaseFluent<A>{
  public AWSMachineProviderConfigFluent() {
  }
  
  public AWSMachineProviderConfigFluent(AWSMachineProviderConfig instance) {
    this.copyInstance(instance);
  }
  private AWSResourceReferenceBuilder ami;
  private String apiVersion;
  private ArrayList<BlockDeviceMappingSpecBuilder> blockDevices = new ArrayList<BlockDeviceMappingSpecBuilder>();
  private String capacityReservationId;
  private LocalObjectReferenceBuilder credentialsSecret;
  private Long deviceIndex;
  private AWSResourceReferenceBuilder iamInstanceProfile;
  private String instanceType;
  private String keyName;
  private String kind;
  private ArrayList<LoadBalancerReferenceBuilder> loadBalancers = new ArrayList<LoadBalancerReferenceBuilder>();
  private ObjectMetaBuilder metadata;
  private MetadataServiceOptionsBuilder metadataServiceOptions;
  private String networkInterfaceType;
  private PlacementBuilder placement;
  private String placementGroupName;
  private Integer placementGroupPartition;
  private Boolean publicIp;
  private ArrayList<AWSResourceReferenceBuilder> securityGroups = new ArrayList<AWSResourceReferenceBuilder>();
  private SpotMarketOptionsBuilder spotMarketOptions;
  private AWSResourceReferenceBuilder subnet;
  private ArrayList<TagSpecificationBuilder> tags = new ArrayList<TagSpecificationBuilder>();
  private LocalObjectReferenceBuilder userDataSecret;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AWSMachineProviderConfig instance) {
    instance = (instance != null ? instance : new AWSMachineProviderConfig());
    if (instance != null) {
          this.withAmi(instance.getAmi());
          this.withApiVersion(instance.getApiVersion());
          this.withBlockDevices(instance.getBlockDevices());
          this.withCapacityReservationId(instance.getCapacityReservationId());
          this.withCredentialsSecret(instance.getCredentialsSecret());
          this.withDeviceIndex(instance.getDeviceIndex());
          this.withIamInstanceProfile(instance.getIamInstanceProfile());
          this.withInstanceType(instance.getInstanceType());
          this.withKeyName(instance.getKeyName());
          this.withKind(instance.getKind());
          this.withLoadBalancers(instance.getLoadBalancers());
          this.withMetadata(instance.getMetadata());
          this.withMetadataServiceOptions(instance.getMetadataServiceOptions());
          this.withNetworkInterfaceType(instance.getNetworkInterfaceType());
          this.withPlacement(instance.getPlacement());
          this.withPlacementGroupName(instance.getPlacementGroupName());
          this.withPlacementGroupPartition(instance.getPlacementGroupPartition());
          this.withPublicIp(instance.getPublicIp());
          this.withSecurityGroups(instance.getSecurityGroups());
          this.withSpotMarketOptions(instance.getSpotMarketOptions());
          this.withSubnet(instance.getSubnet());
          this.withTags(instance.getTags());
          this.withUserDataSecret(instance.getUserDataSecret());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AWSResourceReference buildAmi() {
    return this.ami != null ? this.ami.build() : null;
  }
  
  public A withAmi(AWSResourceReference ami) {
    this._visitables.remove("ami");
    if (ami != null) {
        this.ami = new AWSResourceReferenceBuilder(ami);
        this._visitables.get("ami").add(this.ami);
    } else {
        this.ami = null;
        this._visitables.get("ami").remove(this.ami);
    }
    return (A) this;
  }
  
  public boolean hasAmi() {
    return this.ami != null;
  }
  
  public AmiNested<A> withNewAmi() {
    return new AmiNested(null);
  }
  
  public AmiNested<A> withNewAmiLike(AWSResourceReference item) {
    return new AmiNested(item);
  }
  
  public AmiNested<A> editAmi() {
    return withNewAmiLike(java.util.Optional.ofNullable(buildAmi()).orElse(null));
  }
  
  public AmiNested<A> editOrNewAmi() {
    return withNewAmiLike(java.util.Optional.ofNullable(buildAmi()).orElse(new AWSResourceReferenceBuilder().build()));
  }
  
  public AmiNested<A> editOrNewAmiLike(AWSResourceReference item) {
    return withNewAmiLike(java.util.Optional.ofNullable(buildAmi()).orElse(item));
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public A addToBlockDevices(int index,BlockDeviceMappingSpec item) {
    if (this.blockDevices == null) {this.blockDevices = new ArrayList<BlockDeviceMappingSpecBuilder>();}
    BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);
    if (index < 0 || index >= blockDevices.size()) { _visitables.get("blockDevices").add(builder); blockDevices.add(builder); } else { _visitables.get("blockDevices").add(index, builder); blockDevices.add(index, builder);}
    return (A)this;
  }
  
  public A setToBlockDevices(int index,BlockDeviceMappingSpec item) {
    if (this.blockDevices == null) {this.blockDevices = new ArrayList<BlockDeviceMappingSpecBuilder>();}
    BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);
    if (index < 0 || index >= blockDevices.size()) { _visitables.get("blockDevices").add(builder); blockDevices.add(builder); } else { _visitables.get("blockDevices").set(index, builder); blockDevices.set(index, builder);}
    return (A)this;
  }
  
  public A addToBlockDevices(io.fabric8.openshift.api.model.machine.v1beta1.BlockDeviceMappingSpec... items) {
    if (this.blockDevices == null) {this.blockDevices = new ArrayList<BlockDeviceMappingSpecBuilder>();}
    for (BlockDeviceMappingSpec item : items) {BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);_visitables.get("blockDevices").add(builder);this.blockDevices.add(builder);} return (A)this;
  }
  
  public A addAllToBlockDevices(Collection<BlockDeviceMappingSpec> items) {
    if (this.blockDevices == null) {this.blockDevices = new ArrayList<BlockDeviceMappingSpecBuilder>();}
    for (BlockDeviceMappingSpec item : items) {BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);_visitables.get("blockDevices").add(builder);this.blockDevices.add(builder);} return (A)this;
  }
  
  public A removeFromBlockDevices(io.fabric8.openshift.api.model.machine.v1beta1.BlockDeviceMappingSpec... items) {
    if (this.blockDevices == null) return (A)this;
    for (BlockDeviceMappingSpec item : items) {BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);_visitables.get("blockDevices").remove(builder); this.blockDevices.remove(builder);} return (A)this;
  }
  
  public A removeAllFromBlockDevices(Collection<BlockDeviceMappingSpec> items) {
    if (this.blockDevices == null) return (A)this;
    for (BlockDeviceMappingSpec item : items) {BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);_visitables.get("blockDevices").remove(builder); this.blockDevices.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromBlockDevices(Predicate<BlockDeviceMappingSpecBuilder> predicate) {
    if (blockDevices == null) return (A) this;
    final Iterator<BlockDeviceMappingSpecBuilder> each = blockDevices.iterator();
    final List visitables = _visitables.get("blockDevices");
    while (each.hasNext()) {
      BlockDeviceMappingSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<BlockDeviceMappingSpec> buildBlockDevices() {
    return this.blockDevices != null ? build(blockDevices) : null;
  }
  
  public BlockDeviceMappingSpec buildBlockDevice(int index) {
    return this.blockDevices.get(index).build();
  }
  
  public BlockDeviceMappingSpec buildFirstBlockDevice() {
    return this.blockDevices.get(0).build();
  }
  
  public BlockDeviceMappingSpec buildLastBlockDevice() {
    return this.blockDevices.get(blockDevices.size() - 1).build();
  }
  
  public BlockDeviceMappingSpec buildMatchingBlockDevice(Predicate<BlockDeviceMappingSpecBuilder> predicate) {
      for (BlockDeviceMappingSpecBuilder item : blockDevices) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingBlockDevice(Predicate<BlockDeviceMappingSpecBuilder> predicate) {
      for (BlockDeviceMappingSpecBuilder item : blockDevices) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBlockDevices(List<BlockDeviceMappingSpec> blockDevices) {
    if (this.blockDevices != null) {
      this._visitables.get("blockDevices").clear();
    }
    if (blockDevices != null) {
        this.blockDevices = new ArrayList();
        for (BlockDeviceMappingSpec item : blockDevices) {
          this.addToBlockDevices(item);
        }
    } else {
      this.blockDevices = null;
    }
    return (A) this;
  }
  
  public A withBlockDevices(io.fabric8.openshift.api.model.machine.v1beta1.BlockDeviceMappingSpec... blockDevices) {
    if (this.blockDevices != null) {
        this.blockDevices.clear();
        _visitables.remove("blockDevices");
    }
    if (blockDevices != null) {
      for (BlockDeviceMappingSpec item : blockDevices) {
        this.addToBlockDevices(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBlockDevices() {
    return this.blockDevices != null && !this.blockDevices.isEmpty();
  }
  
  public BlockDevicesNested<A> addNewBlockDevice() {
    return new BlockDevicesNested(-1, null);
  }
  
  public BlockDevicesNested<A> addNewBlockDeviceLike(BlockDeviceMappingSpec item) {
    return new BlockDevicesNested(-1, item);
  }
  
  public BlockDevicesNested<A> setNewBlockDeviceLike(int index,BlockDeviceMappingSpec item) {
    return new BlockDevicesNested(index, item);
  }
  
  public BlockDevicesNested<A> editBlockDevice(int index) {
    if (blockDevices.size() <= index) throw new RuntimeException("Can't edit blockDevices. Index exceeds size.");
    return setNewBlockDeviceLike(index, buildBlockDevice(index));
  }
  
  public BlockDevicesNested<A> editFirstBlockDevice() {
    if (blockDevices.size() == 0) throw new RuntimeException("Can't edit first blockDevices. The list is empty.");
    return setNewBlockDeviceLike(0, buildBlockDevice(0));
  }
  
  public BlockDevicesNested<A> editLastBlockDevice() {
    int index = blockDevices.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last blockDevices. The list is empty.");
    return setNewBlockDeviceLike(index, buildBlockDevice(index));
  }
  
  public BlockDevicesNested<A> editMatchingBlockDevice(Predicate<BlockDeviceMappingSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<blockDevices.size();i++) { 
    if (predicate.test(blockDevices.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching blockDevices. No match found.");
    return setNewBlockDeviceLike(index, buildBlockDevice(index));
  }
  
  public String getCapacityReservationId() {
    return this.capacityReservationId;
  }
  
  public A withCapacityReservationId(String capacityReservationId) {
    this.capacityReservationId = capacityReservationId;
    return (A) this;
  }
  
  public boolean hasCapacityReservationId() {
    return this.capacityReservationId != null;
  }
  
  public LocalObjectReference buildCredentialsSecret() {
    return this.credentialsSecret != null ? this.credentialsSecret.build() : null;
  }
  
  public A withCredentialsSecret(LocalObjectReference credentialsSecret) {
    this._visitables.remove("credentialsSecret");
    if (credentialsSecret != null) {
        this.credentialsSecret = new LocalObjectReferenceBuilder(credentialsSecret);
        this._visitables.get("credentialsSecret").add(this.credentialsSecret);
    } else {
        this.credentialsSecret = null;
        this._visitables.get("credentialsSecret").remove(this.credentialsSecret);
    }
    return (A) this;
  }
  
  public boolean hasCredentialsSecret() {
    return this.credentialsSecret != null;
  }
  
  public A withNewCredentialsSecret(String name) {
    return (A)withCredentialsSecret(new LocalObjectReference(name));
  }
  
  public CredentialsSecretNested<A> withNewCredentialsSecret() {
    return new CredentialsSecretNested(null);
  }
  
  public CredentialsSecretNested<A> withNewCredentialsSecretLike(LocalObjectReference item) {
    return new CredentialsSecretNested(item);
  }
  
  public CredentialsSecretNested<A> editCredentialsSecret() {
    return withNewCredentialsSecretLike(java.util.Optional.ofNullable(buildCredentialsSecret()).orElse(null));
  }
  
  public CredentialsSecretNested<A> editOrNewCredentialsSecret() {
    return withNewCredentialsSecretLike(java.util.Optional.ofNullable(buildCredentialsSecret()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public CredentialsSecretNested<A> editOrNewCredentialsSecretLike(LocalObjectReference item) {
    return withNewCredentialsSecretLike(java.util.Optional.ofNullable(buildCredentialsSecret()).orElse(item));
  }
  
  public Long getDeviceIndex() {
    return this.deviceIndex;
  }
  
  public A withDeviceIndex(Long deviceIndex) {
    this.deviceIndex = deviceIndex;
    return (A) this;
  }
  
  public boolean hasDeviceIndex() {
    return this.deviceIndex != null;
  }
  
  public AWSResourceReference buildIamInstanceProfile() {
    return this.iamInstanceProfile != null ? this.iamInstanceProfile.build() : null;
  }
  
  public A withIamInstanceProfile(AWSResourceReference iamInstanceProfile) {
    this._visitables.remove("iamInstanceProfile");
    if (iamInstanceProfile != null) {
        this.iamInstanceProfile = new AWSResourceReferenceBuilder(iamInstanceProfile);
        this._visitables.get("iamInstanceProfile").add(this.iamInstanceProfile);
    } else {
        this.iamInstanceProfile = null;
        this._visitables.get("iamInstanceProfile").remove(this.iamInstanceProfile);
    }
    return (A) this;
  }
  
  public boolean hasIamInstanceProfile() {
    return this.iamInstanceProfile != null;
  }
  
  public IamInstanceProfileNested<A> withNewIamInstanceProfile() {
    return new IamInstanceProfileNested(null);
  }
  
  public IamInstanceProfileNested<A> withNewIamInstanceProfileLike(AWSResourceReference item) {
    return new IamInstanceProfileNested(item);
  }
  
  public IamInstanceProfileNested<A> editIamInstanceProfile() {
    return withNewIamInstanceProfileLike(java.util.Optional.ofNullable(buildIamInstanceProfile()).orElse(null));
  }
  
  public IamInstanceProfileNested<A> editOrNewIamInstanceProfile() {
    return withNewIamInstanceProfileLike(java.util.Optional.ofNullable(buildIamInstanceProfile()).orElse(new AWSResourceReferenceBuilder().build()));
  }
  
  public IamInstanceProfileNested<A> editOrNewIamInstanceProfileLike(AWSResourceReference item) {
    return withNewIamInstanceProfileLike(java.util.Optional.ofNullable(buildIamInstanceProfile()).orElse(item));
  }
  
  public String getInstanceType() {
    return this.instanceType;
  }
  
  public A withInstanceType(String instanceType) {
    this.instanceType = instanceType;
    return (A) this;
  }
  
  public boolean hasInstanceType() {
    return this.instanceType != null;
  }
  
  public String getKeyName() {
    return this.keyName;
  }
  
  public A withKeyName(String keyName) {
    this.keyName = keyName;
    return (A) this;
  }
  
  public boolean hasKeyName() {
    return this.keyName != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public A addToLoadBalancers(int index,LoadBalancerReference item) {
    if (this.loadBalancers == null) {this.loadBalancers = new ArrayList<LoadBalancerReferenceBuilder>();}
    LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
    if (index < 0 || index >= loadBalancers.size()) { _visitables.get("loadBalancers").add(builder); loadBalancers.add(builder); } else { _visitables.get("loadBalancers").add(index, builder); loadBalancers.add(index, builder);}
    return (A)this;
  }
  
  public A setToLoadBalancers(int index,LoadBalancerReference item) {
    if (this.loadBalancers == null) {this.loadBalancers = new ArrayList<LoadBalancerReferenceBuilder>();}
    LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
    if (index < 0 || index >= loadBalancers.size()) { _visitables.get("loadBalancers").add(builder); loadBalancers.add(builder); } else { _visitables.get("loadBalancers").set(index, builder); loadBalancers.set(index, builder);}
    return (A)this;
  }
  
  public A addToLoadBalancers(io.fabric8.openshift.api.model.machine.v1beta1.LoadBalancerReference... items) {
    if (this.loadBalancers == null) {this.loadBalancers = new ArrayList<LoadBalancerReferenceBuilder>();}
    for (LoadBalancerReference item : items) {LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);_visitables.get("loadBalancers").add(builder);this.loadBalancers.add(builder);} return (A)this;
  }
  
  public A addAllToLoadBalancers(Collection<LoadBalancerReference> items) {
    if (this.loadBalancers == null) {this.loadBalancers = new ArrayList<LoadBalancerReferenceBuilder>();}
    for (LoadBalancerReference item : items) {LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);_visitables.get("loadBalancers").add(builder);this.loadBalancers.add(builder);} return (A)this;
  }
  
  public A removeFromLoadBalancers(io.fabric8.openshift.api.model.machine.v1beta1.LoadBalancerReference... items) {
    if (this.loadBalancers == null) return (A)this;
    for (LoadBalancerReference item : items) {LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);_visitables.get("loadBalancers").remove(builder); this.loadBalancers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromLoadBalancers(Collection<LoadBalancerReference> items) {
    if (this.loadBalancers == null) return (A)this;
    for (LoadBalancerReference item : items) {LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);_visitables.get("loadBalancers").remove(builder); this.loadBalancers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromLoadBalancers(Predicate<LoadBalancerReferenceBuilder> predicate) {
    if (loadBalancers == null) return (A) this;
    final Iterator<LoadBalancerReferenceBuilder> each = loadBalancers.iterator();
    final List visitables = _visitables.get("loadBalancers");
    while (each.hasNext()) {
      LoadBalancerReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LoadBalancerReference> buildLoadBalancers() {
    return this.loadBalancers != null ? build(loadBalancers) : null;
  }
  
  public LoadBalancerReference buildLoadBalancer(int index) {
    return this.loadBalancers.get(index).build();
  }
  
  public LoadBalancerReference buildFirstLoadBalancer() {
    return this.loadBalancers.get(0).build();
  }
  
  public LoadBalancerReference buildLastLoadBalancer() {
    return this.loadBalancers.get(loadBalancers.size() - 1).build();
  }
  
  public LoadBalancerReference buildMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
      for (LoadBalancerReferenceBuilder item : loadBalancers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
      for (LoadBalancerReferenceBuilder item : loadBalancers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withLoadBalancers(List<LoadBalancerReference> loadBalancers) {
    if (this.loadBalancers != null) {
      this._visitables.get("loadBalancers").clear();
    }
    if (loadBalancers != null) {
        this.loadBalancers = new ArrayList();
        for (LoadBalancerReference item : loadBalancers) {
          this.addToLoadBalancers(item);
        }
    } else {
      this.loadBalancers = null;
    }
    return (A) this;
  }
  
  public A withLoadBalancers(io.fabric8.openshift.api.model.machine.v1beta1.LoadBalancerReference... loadBalancers) {
    if (this.loadBalancers != null) {
        this.loadBalancers.clear();
        _visitables.remove("loadBalancers");
    }
    if (loadBalancers != null) {
      for (LoadBalancerReference item : loadBalancers) {
        this.addToLoadBalancers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasLoadBalancers() {
    return this.loadBalancers != null && !this.loadBalancers.isEmpty();
  }
  
  public A addNewLoadBalancer(String name,String type) {
    return (A)addToLoadBalancers(new LoadBalancerReference(name, type));
  }
  
  public LoadBalancersNested<A> addNewLoadBalancer() {
    return new LoadBalancersNested(-1, null);
  }
  
  public LoadBalancersNested<A> addNewLoadBalancerLike(LoadBalancerReference item) {
    return new LoadBalancersNested(-1, item);
  }
  
  public LoadBalancersNested<A> setNewLoadBalancerLike(int index,LoadBalancerReference item) {
    return new LoadBalancersNested(index, item);
  }
  
  public LoadBalancersNested<A> editLoadBalancer(int index) {
    if (loadBalancers.size() <= index) throw new RuntimeException("Can't edit loadBalancers. Index exceeds size.");
    return setNewLoadBalancerLike(index, buildLoadBalancer(index));
  }
  
  public LoadBalancersNested<A> editFirstLoadBalancer() {
    if (loadBalancers.size() == 0) throw new RuntimeException("Can't edit first loadBalancers. The list is empty.");
    return setNewLoadBalancerLike(0, buildLoadBalancer(0));
  }
  
  public LoadBalancersNested<A> editLastLoadBalancer() {
    int index = loadBalancers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last loadBalancers. The list is empty.");
    return setNewLoadBalancerLike(index, buildLoadBalancer(index));
  }
  
  public LoadBalancersNested<A> editMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<loadBalancers.size();i++) { 
    if (predicate.test(loadBalancers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching loadBalancers. No match found.");
    return setNewLoadBalancerLike(index, buildLoadBalancer(index));
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public MetadataServiceOptions buildMetadataServiceOptions() {
    return this.metadataServiceOptions != null ? this.metadataServiceOptions.build() : null;
  }
  
  public A withMetadataServiceOptions(MetadataServiceOptions metadataServiceOptions) {
    this._visitables.remove("metadataServiceOptions");
    if (metadataServiceOptions != null) {
        this.metadataServiceOptions = new MetadataServiceOptionsBuilder(metadataServiceOptions);
        this._visitables.get("metadataServiceOptions").add(this.metadataServiceOptions);
    } else {
        this.metadataServiceOptions = null;
        this._visitables.get("metadataServiceOptions").remove(this.metadataServiceOptions);
    }
    return (A) this;
  }
  
  public boolean hasMetadataServiceOptions() {
    return this.metadataServiceOptions != null;
  }
  
  public A withNewMetadataServiceOptions(String authentication) {
    return (A)withMetadataServiceOptions(new MetadataServiceOptions(authentication));
  }
  
  public MetadataServiceOptionsNested<A> withNewMetadataServiceOptions() {
    return new MetadataServiceOptionsNested(null);
  }
  
  public MetadataServiceOptionsNested<A> withNewMetadataServiceOptionsLike(MetadataServiceOptions item) {
    return new MetadataServiceOptionsNested(item);
  }
  
  public MetadataServiceOptionsNested<A> editMetadataServiceOptions() {
    return withNewMetadataServiceOptionsLike(java.util.Optional.ofNullable(buildMetadataServiceOptions()).orElse(null));
  }
  
  public MetadataServiceOptionsNested<A> editOrNewMetadataServiceOptions() {
    return withNewMetadataServiceOptionsLike(java.util.Optional.ofNullable(buildMetadataServiceOptions()).orElse(new MetadataServiceOptionsBuilder().build()));
  }
  
  public MetadataServiceOptionsNested<A> editOrNewMetadataServiceOptionsLike(MetadataServiceOptions item) {
    return withNewMetadataServiceOptionsLike(java.util.Optional.ofNullable(buildMetadataServiceOptions()).orElse(item));
  }
  
  public String getNetworkInterfaceType() {
    return this.networkInterfaceType;
  }
  
  public A withNetworkInterfaceType(String networkInterfaceType) {
    this.networkInterfaceType = networkInterfaceType;
    return (A) this;
  }
  
  public boolean hasNetworkInterfaceType() {
    return this.networkInterfaceType != null;
  }
  
  public Placement buildPlacement() {
    return this.placement != null ? this.placement.build() : null;
  }
  
  public A withPlacement(Placement placement) {
    this._visitables.remove("placement");
    if (placement != null) {
        this.placement = new PlacementBuilder(placement);
        this._visitables.get("placement").add(this.placement);
    } else {
        this.placement = null;
        this._visitables.get("placement").remove(this.placement);
    }
    return (A) this;
  }
  
  public boolean hasPlacement() {
    return this.placement != null;
  }
  
  public A withNewPlacement(String availabilityZone,String region,String tenancy) {
    return (A)withPlacement(new Placement(availabilityZone, region, tenancy));
  }
  
  public PlacementNested<A> withNewPlacement() {
    return new PlacementNested(null);
  }
  
  public PlacementNested<A> withNewPlacementLike(Placement item) {
    return new PlacementNested(item);
  }
  
  public PlacementNested<A> editPlacement() {
    return withNewPlacementLike(java.util.Optional.ofNullable(buildPlacement()).orElse(null));
  }
  
  public PlacementNested<A> editOrNewPlacement() {
    return withNewPlacementLike(java.util.Optional.ofNullable(buildPlacement()).orElse(new PlacementBuilder().build()));
  }
  
  public PlacementNested<A> editOrNewPlacementLike(Placement item) {
    return withNewPlacementLike(java.util.Optional.ofNullable(buildPlacement()).orElse(item));
  }
  
  public String getPlacementGroupName() {
    return this.placementGroupName;
  }
  
  public A withPlacementGroupName(String placementGroupName) {
    this.placementGroupName = placementGroupName;
    return (A) this;
  }
  
  public boolean hasPlacementGroupName() {
    return this.placementGroupName != null;
  }
  
  public Integer getPlacementGroupPartition() {
    return this.placementGroupPartition;
  }
  
  public A withPlacementGroupPartition(Integer placementGroupPartition) {
    this.placementGroupPartition = placementGroupPartition;
    return (A) this;
  }
  
  public boolean hasPlacementGroupPartition() {
    return this.placementGroupPartition != null;
  }
  
  public Boolean getPublicIp() {
    return this.publicIp;
  }
  
  public A withPublicIp(Boolean publicIp) {
    this.publicIp = publicIp;
    return (A) this;
  }
  
  public boolean hasPublicIp() {
    return this.publicIp != null;
  }
  
  public A addToSecurityGroups(int index,AWSResourceReference item) {
    if (this.securityGroups == null) {this.securityGroups = new ArrayList<AWSResourceReferenceBuilder>();}
    AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);
    if (index < 0 || index >= securityGroups.size()) { _visitables.get("securityGroups").add(builder); securityGroups.add(builder); } else { _visitables.get("securityGroups").add(index, builder); securityGroups.add(index, builder);}
    return (A)this;
  }
  
  public A setToSecurityGroups(int index,AWSResourceReference item) {
    if (this.securityGroups == null) {this.securityGroups = new ArrayList<AWSResourceReferenceBuilder>();}
    AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);
    if (index < 0 || index >= securityGroups.size()) { _visitables.get("securityGroups").add(builder); securityGroups.add(builder); } else { _visitables.get("securityGroups").set(index, builder); securityGroups.set(index, builder);}
    return (A)this;
  }
  
  public A addToSecurityGroups(io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReference... items) {
    if (this.securityGroups == null) {this.securityGroups = new ArrayList<AWSResourceReferenceBuilder>();}
    for (AWSResourceReference item : items) {AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);_visitables.get("securityGroups").add(builder);this.securityGroups.add(builder);} return (A)this;
  }
  
  public A addAllToSecurityGroups(Collection<AWSResourceReference> items) {
    if (this.securityGroups == null) {this.securityGroups = new ArrayList<AWSResourceReferenceBuilder>();}
    for (AWSResourceReference item : items) {AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);_visitables.get("securityGroups").add(builder);this.securityGroups.add(builder);} return (A)this;
  }
  
  public A removeFromSecurityGroups(io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReference... items) {
    if (this.securityGroups == null) return (A)this;
    for (AWSResourceReference item : items) {AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);_visitables.get("securityGroups").remove(builder); this.securityGroups.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSecurityGroups(Collection<AWSResourceReference> items) {
    if (this.securityGroups == null) return (A)this;
    for (AWSResourceReference item : items) {AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);_visitables.get("securityGroups").remove(builder); this.securityGroups.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSecurityGroups(Predicate<AWSResourceReferenceBuilder> predicate) {
    if (securityGroups == null) return (A) this;
    final Iterator<AWSResourceReferenceBuilder> each = securityGroups.iterator();
    final List visitables = _visitables.get("securityGroups");
    while (each.hasNext()) {
      AWSResourceReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AWSResourceReference> buildSecurityGroups() {
    return this.securityGroups != null ? build(securityGroups) : null;
  }
  
  public AWSResourceReference buildSecurityGroup(int index) {
    return this.securityGroups.get(index).build();
  }
  
  public AWSResourceReference buildFirstSecurityGroup() {
    return this.securityGroups.get(0).build();
  }
  
  public AWSResourceReference buildLastSecurityGroup() {
    return this.securityGroups.get(securityGroups.size() - 1).build();
  }
  
  public AWSResourceReference buildMatchingSecurityGroup(Predicate<AWSResourceReferenceBuilder> predicate) {
      for (AWSResourceReferenceBuilder item : securityGroups) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSecurityGroup(Predicate<AWSResourceReferenceBuilder> predicate) {
      for (AWSResourceReferenceBuilder item : securityGroups) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSecurityGroups(List<AWSResourceReference> securityGroups) {
    if (this.securityGroups != null) {
      this._visitables.get("securityGroups").clear();
    }
    if (securityGroups != null) {
        this.securityGroups = new ArrayList();
        for (AWSResourceReference item : securityGroups) {
          this.addToSecurityGroups(item);
        }
    } else {
      this.securityGroups = null;
    }
    return (A) this;
  }
  
  public A withSecurityGroups(io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReference... securityGroups) {
    if (this.securityGroups != null) {
        this.securityGroups.clear();
        _visitables.remove("securityGroups");
    }
    if (securityGroups != null) {
      for (AWSResourceReference item : securityGroups) {
        this.addToSecurityGroups(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSecurityGroups() {
    return this.securityGroups != null && !this.securityGroups.isEmpty();
  }
  
  public SecurityGroupsNested<A> addNewSecurityGroup() {
    return new SecurityGroupsNested(-1, null);
  }
  
  public SecurityGroupsNested<A> addNewSecurityGroupLike(AWSResourceReference item) {
    return new SecurityGroupsNested(-1, item);
  }
  
  public SecurityGroupsNested<A> setNewSecurityGroupLike(int index,AWSResourceReference item) {
    return new SecurityGroupsNested(index, item);
  }
  
  public SecurityGroupsNested<A> editSecurityGroup(int index) {
    if (securityGroups.size() <= index) throw new RuntimeException("Can't edit securityGroups. Index exceeds size.");
    return setNewSecurityGroupLike(index, buildSecurityGroup(index));
  }
  
  public SecurityGroupsNested<A> editFirstSecurityGroup() {
    if (securityGroups.size() == 0) throw new RuntimeException("Can't edit first securityGroups. The list is empty.");
    return setNewSecurityGroupLike(0, buildSecurityGroup(0));
  }
  
  public SecurityGroupsNested<A> editLastSecurityGroup() {
    int index = securityGroups.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last securityGroups. The list is empty.");
    return setNewSecurityGroupLike(index, buildSecurityGroup(index));
  }
  
  public SecurityGroupsNested<A> editMatchingSecurityGroup(Predicate<AWSResourceReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<securityGroups.size();i++) { 
    if (predicate.test(securityGroups.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching securityGroups. No match found.");
    return setNewSecurityGroupLike(index, buildSecurityGroup(index));
  }
  
  public SpotMarketOptions buildSpotMarketOptions() {
    return this.spotMarketOptions != null ? this.spotMarketOptions.build() : null;
  }
  
  public A withSpotMarketOptions(SpotMarketOptions spotMarketOptions) {
    this._visitables.remove("spotMarketOptions");
    if (spotMarketOptions != null) {
        this.spotMarketOptions = new SpotMarketOptionsBuilder(spotMarketOptions);
        this._visitables.get("spotMarketOptions").add(this.spotMarketOptions);
    } else {
        this.spotMarketOptions = null;
        this._visitables.get("spotMarketOptions").remove(this.spotMarketOptions);
    }
    return (A) this;
  }
  
  public boolean hasSpotMarketOptions() {
    return this.spotMarketOptions != null;
  }
  
  public A withNewSpotMarketOptions(String maxPrice) {
    return (A)withSpotMarketOptions(new SpotMarketOptions(maxPrice));
  }
  
  public SpotMarketOptionsNested<A> withNewSpotMarketOptions() {
    return new SpotMarketOptionsNested(null);
  }
  
  public SpotMarketOptionsNested<A> withNewSpotMarketOptionsLike(SpotMarketOptions item) {
    return new SpotMarketOptionsNested(item);
  }
  
  public SpotMarketOptionsNested<A> editSpotMarketOptions() {
    return withNewSpotMarketOptionsLike(java.util.Optional.ofNullable(buildSpotMarketOptions()).orElse(null));
  }
  
  public SpotMarketOptionsNested<A> editOrNewSpotMarketOptions() {
    return withNewSpotMarketOptionsLike(java.util.Optional.ofNullable(buildSpotMarketOptions()).orElse(new SpotMarketOptionsBuilder().build()));
  }
  
  public SpotMarketOptionsNested<A> editOrNewSpotMarketOptionsLike(SpotMarketOptions item) {
    return withNewSpotMarketOptionsLike(java.util.Optional.ofNullable(buildSpotMarketOptions()).orElse(item));
  }
  
  public AWSResourceReference buildSubnet() {
    return this.subnet != null ? this.subnet.build() : null;
  }
  
  public A withSubnet(AWSResourceReference subnet) {
    this._visitables.remove("subnet");
    if (subnet != null) {
        this.subnet = new AWSResourceReferenceBuilder(subnet);
        this._visitables.get("subnet").add(this.subnet);
    } else {
        this.subnet = null;
        this._visitables.get("subnet").remove(this.subnet);
    }
    return (A) this;
  }
  
  public boolean hasSubnet() {
    return this.subnet != null;
  }
  
  public SubnetNested<A> withNewSubnet() {
    return new SubnetNested(null);
  }
  
  public SubnetNested<A> withNewSubnetLike(AWSResourceReference item) {
    return new SubnetNested(item);
  }
  
  public SubnetNested<A> editSubnet() {
    return withNewSubnetLike(java.util.Optional.ofNullable(buildSubnet()).orElse(null));
  }
  
  public SubnetNested<A> editOrNewSubnet() {
    return withNewSubnetLike(java.util.Optional.ofNullable(buildSubnet()).orElse(new AWSResourceReferenceBuilder().build()));
  }
  
  public SubnetNested<A> editOrNewSubnetLike(AWSResourceReference item) {
    return withNewSubnetLike(java.util.Optional.ofNullable(buildSubnet()).orElse(item));
  }
  
  public A addToTags(int index,TagSpecification item) {
    if (this.tags == null) {this.tags = new ArrayList<TagSpecificationBuilder>();}
    TagSpecificationBuilder builder = new TagSpecificationBuilder(item);
    if (index < 0 || index >= tags.size()) { _visitables.get("tags").add(builder); tags.add(builder); } else { _visitables.get("tags").add(index, builder); tags.add(index, builder);}
    return (A)this;
  }
  
  public A setToTags(int index,TagSpecification item) {
    if (this.tags == null) {this.tags = new ArrayList<TagSpecificationBuilder>();}
    TagSpecificationBuilder builder = new TagSpecificationBuilder(item);
    if (index < 0 || index >= tags.size()) { _visitables.get("tags").add(builder); tags.add(builder); } else { _visitables.get("tags").set(index, builder); tags.set(index, builder);}
    return (A)this;
  }
  
  public A addToTags(io.fabric8.openshift.api.model.machine.v1beta1.TagSpecification... items) {
    if (this.tags == null) {this.tags = new ArrayList<TagSpecificationBuilder>();}
    for (TagSpecification item : items) {TagSpecificationBuilder builder = new TagSpecificationBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
  }
  
  public A addAllToTags(Collection<TagSpecification> items) {
    if (this.tags == null) {this.tags = new ArrayList<TagSpecificationBuilder>();}
    for (TagSpecification item : items) {TagSpecificationBuilder builder = new TagSpecificationBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
  }
  
  public A removeFromTags(io.fabric8.openshift.api.model.machine.v1beta1.TagSpecification... items) {
    if (this.tags == null) return (A)this;
    for (TagSpecification item : items) {TagSpecificationBuilder builder = new TagSpecificationBuilder(item);_visitables.get("tags").remove(builder); this.tags.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTags(Collection<TagSpecification> items) {
    if (this.tags == null) return (A)this;
    for (TagSpecification item : items) {TagSpecificationBuilder builder = new TagSpecificationBuilder(item);_visitables.get("tags").remove(builder); this.tags.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTags(Predicate<TagSpecificationBuilder> predicate) {
    if (tags == null) return (A) this;
    final Iterator<TagSpecificationBuilder> each = tags.iterator();
    final List visitables = _visitables.get("tags");
    while (each.hasNext()) {
      TagSpecificationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TagSpecification> buildTags() {
    return this.tags != null ? build(tags) : null;
  }
  
  public TagSpecification buildTag(int index) {
    return this.tags.get(index).build();
  }
  
  public TagSpecification buildFirstTag() {
    return this.tags.get(0).build();
  }
  
  public TagSpecification buildLastTag() {
    return this.tags.get(tags.size() - 1).build();
  }
  
  public TagSpecification buildMatchingTag(Predicate<TagSpecificationBuilder> predicate) {
      for (TagSpecificationBuilder item : tags) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTag(Predicate<TagSpecificationBuilder> predicate) {
      for (TagSpecificationBuilder item : tags) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTags(List<TagSpecification> tags) {
    if (this.tags != null) {
      this._visitables.get("tags").clear();
    }
    if (tags != null) {
        this.tags = new ArrayList();
        for (TagSpecification item : tags) {
          this.addToTags(item);
        }
    } else {
      this.tags = null;
    }
    return (A) this;
  }
  
  public A withTags(io.fabric8.openshift.api.model.machine.v1beta1.TagSpecification... tags) {
    if (this.tags != null) {
        this.tags.clear();
        _visitables.remove("tags");
    }
    if (tags != null) {
      for (TagSpecification item : tags) {
        this.addToTags(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTags() {
    return this.tags != null && !this.tags.isEmpty();
  }
  
  public A addNewTag(String name,String value) {
    return (A)addToTags(new TagSpecification(name, value));
  }
  
  public TagsNested<A> addNewTag() {
    return new TagsNested(-1, null);
  }
  
  public TagsNested<A> addNewTagLike(TagSpecification item) {
    return new TagsNested(-1, item);
  }
  
  public TagsNested<A> setNewTagLike(int index,TagSpecification item) {
    return new TagsNested(index, item);
  }
  
  public TagsNested<A> editTag(int index) {
    if (tags.size() <= index) throw new RuntimeException("Can't edit tags. Index exceeds size.");
    return setNewTagLike(index, buildTag(index));
  }
  
  public TagsNested<A> editFirstTag() {
    if (tags.size() == 0) throw new RuntimeException("Can't edit first tags. The list is empty.");
    return setNewTagLike(0, buildTag(0));
  }
  
  public TagsNested<A> editLastTag() {
    int index = tags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tags. The list is empty.");
    return setNewTagLike(index, buildTag(index));
  }
  
  public TagsNested<A> editMatchingTag(Predicate<TagSpecificationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tags.size();i++) { 
    if (predicate.test(tags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tags. No match found.");
    return setNewTagLike(index, buildTag(index));
  }
  
  public LocalObjectReference buildUserDataSecret() {
    return this.userDataSecret != null ? this.userDataSecret.build() : null;
  }
  
  public A withUserDataSecret(LocalObjectReference userDataSecret) {
    this._visitables.remove("userDataSecret");
    if (userDataSecret != null) {
        this.userDataSecret = new LocalObjectReferenceBuilder(userDataSecret);
        this._visitables.get("userDataSecret").add(this.userDataSecret);
    } else {
        this.userDataSecret = null;
        this._visitables.get("userDataSecret").remove(this.userDataSecret);
    }
    return (A) this;
  }
  
  public boolean hasUserDataSecret() {
    return this.userDataSecret != null;
  }
  
  public A withNewUserDataSecret(String name) {
    return (A)withUserDataSecret(new LocalObjectReference(name));
  }
  
  public UserDataSecretNested<A> withNewUserDataSecret() {
    return new UserDataSecretNested(null);
  }
  
  public UserDataSecretNested<A> withNewUserDataSecretLike(LocalObjectReference item) {
    return new UserDataSecretNested(item);
  }
  
  public UserDataSecretNested<A> editUserDataSecret() {
    return withNewUserDataSecretLike(java.util.Optional.ofNullable(buildUserDataSecret()).orElse(null));
  }
  
  public UserDataSecretNested<A> editOrNewUserDataSecret() {
    return withNewUserDataSecretLike(java.util.Optional.ofNullable(buildUserDataSecret()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public UserDataSecretNested<A> editOrNewUserDataSecretLike(LocalObjectReference item) {
    return withNewUserDataSecretLike(java.util.Optional.ofNullable(buildUserDataSecret()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSMachineProviderConfigFluent that = (AWSMachineProviderConfigFluent) o;
    if (!java.util.Objects.equals(ami, that.ami)) return false;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(blockDevices, that.blockDevices)) return false;
    if (!java.util.Objects.equals(capacityReservationId, that.capacityReservationId)) return false;
    if (!java.util.Objects.equals(credentialsSecret, that.credentialsSecret)) return false;
    if (!java.util.Objects.equals(deviceIndex, that.deviceIndex)) return false;
    if (!java.util.Objects.equals(iamInstanceProfile, that.iamInstanceProfile)) return false;
    if (!java.util.Objects.equals(instanceType, that.instanceType)) return false;
    if (!java.util.Objects.equals(keyName, that.keyName)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(loadBalancers, that.loadBalancers)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(metadataServiceOptions, that.metadataServiceOptions)) return false;
    if (!java.util.Objects.equals(networkInterfaceType, that.networkInterfaceType)) return false;
    if (!java.util.Objects.equals(placement, that.placement)) return false;
    if (!java.util.Objects.equals(placementGroupName, that.placementGroupName)) return false;
    if (!java.util.Objects.equals(placementGroupPartition, that.placementGroupPartition)) return false;
    if (!java.util.Objects.equals(publicIp, that.publicIp)) return false;
    if (!java.util.Objects.equals(securityGroups, that.securityGroups)) return false;
    if (!java.util.Objects.equals(spotMarketOptions, that.spotMarketOptions)) return false;
    if (!java.util.Objects.equals(subnet, that.subnet)) return false;
    if (!java.util.Objects.equals(tags, that.tags)) return false;
    if (!java.util.Objects.equals(userDataSecret, that.userDataSecret)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ami,  apiVersion,  blockDevices,  capacityReservationId,  credentialsSecret,  deviceIndex,  iamInstanceProfile,  instanceType,  keyName,  kind,  loadBalancers,  metadata,  metadataServiceOptions,  networkInterfaceType,  placement,  placementGroupName,  placementGroupPartition,  publicIp,  securityGroups,  spotMarketOptions,  subnet,  tags,  userDataSecret,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ami != null) { sb.append("ami:"); sb.append(ami + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (blockDevices != null && !blockDevices.isEmpty()) { sb.append("blockDevices:"); sb.append(blockDevices + ","); }
    if (capacityReservationId != null) { sb.append("capacityReservationId:"); sb.append(capacityReservationId + ","); }
    if (credentialsSecret != null) { sb.append("credentialsSecret:"); sb.append(credentialsSecret + ","); }
    if (deviceIndex != null) { sb.append("deviceIndex:"); sb.append(deviceIndex + ","); }
    if (iamInstanceProfile != null) { sb.append("iamInstanceProfile:"); sb.append(iamInstanceProfile + ","); }
    if (instanceType != null) { sb.append("instanceType:"); sb.append(instanceType + ","); }
    if (keyName != null) { sb.append("keyName:"); sb.append(keyName + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (loadBalancers != null && !loadBalancers.isEmpty()) { sb.append("loadBalancers:"); sb.append(loadBalancers + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (metadataServiceOptions != null) { sb.append("metadataServiceOptions:"); sb.append(metadataServiceOptions + ","); }
    if (networkInterfaceType != null) { sb.append("networkInterfaceType:"); sb.append(networkInterfaceType + ","); }
    if (placement != null) { sb.append("placement:"); sb.append(placement + ","); }
    if (placementGroupName != null) { sb.append("placementGroupName:"); sb.append(placementGroupName + ","); }
    if (placementGroupPartition != null) { sb.append("placementGroupPartition:"); sb.append(placementGroupPartition + ","); }
    if (publicIp != null) { sb.append("publicIp:"); sb.append(publicIp + ","); }
    if (securityGroups != null && !securityGroups.isEmpty()) { sb.append("securityGroups:"); sb.append(securityGroups + ","); }
    if (spotMarketOptions != null) { sb.append("spotMarketOptions:"); sb.append(spotMarketOptions + ","); }
    if (subnet != null) { sb.append("subnet:"); sb.append(subnet + ","); }
    if (tags != null && !tags.isEmpty()) { sb.append("tags:"); sb.append(tags + ","); }
    if (userDataSecret != null) { sb.append("userDataSecret:"); sb.append(userDataSecret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withPublicIp() {
    return withPublicIp(true);
  }
  public class AmiNested<N> extends AWSResourceReferenceFluent<AmiNested<N>> implements Nested<N>{
    AmiNested(AWSResourceReference item) {
      this.builder = new AWSResourceReferenceBuilder(this, item);
    }
    AWSResourceReferenceBuilder builder;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.withAmi(builder.build());
    }
    
    public N endAmi() {
      return and();
    }
    
  
  }
  public class BlockDevicesNested<N> extends BlockDeviceMappingSpecFluent<BlockDevicesNested<N>> implements Nested<N>{
    BlockDevicesNested(int index,BlockDeviceMappingSpec item) {
      this.index = index;
      this.builder = new BlockDeviceMappingSpecBuilder(this, item);
    }
    BlockDeviceMappingSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.setToBlockDevices(index,builder.build());
    }
    
    public N endBlockDevice() {
      return and();
    }
    
  
  }
  public class CredentialsSecretNested<N> extends LocalObjectReferenceFluent<CredentialsSecretNested<N>> implements Nested<N>{
    CredentialsSecretNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.withCredentialsSecret(builder.build());
    }
    
    public N endCredentialsSecret() {
      return and();
    }
    
  
  }
  public class IamInstanceProfileNested<N> extends AWSResourceReferenceFluent<IamInstanceProfileNested<N>> implements Nested<N>{
    IamInstanceProfileNested(AWSResourceReference item) {
      this.builder = new AWSResourceReferenceBuilder(this, item);
    }
    AWSResourceReferenceBuilder builder;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.withIamInstanceProfile(builder.build());
    }
    
    public N endIamInstanceProfile() {
      return and();
    }
    
  
  }
  public class LoadBalancersNested<N> extends LoadBalancerReferenceFluent<LoadBalancersNested<N>> implements Nested<N>{
    LoadBalancersNested(int index,LoadBalancerReference item) {
      this.index = index;
      this.builder = new LoadBalancerReferenceBuilder(this, item);
    }
    LoadBalancerReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.setToLoadBalancers(index,builder.build());
    }
    
    public N endLoadBalancer() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class MetadataServiceOptionsNested<N> extends MetadataServiceOptionsFluent<MetadataServiceOptionsNested<N>> implements Nested<N>{
    MetadataServiceOptionsNested(MetadataServiceOptions item) {
      this.builder = new MetadataServiceOptionsBuilder(this, item);
    }
    MetadataServiceOptionsBuilder builder;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.withMetadataServiceOptions(builder.build());
    }
    
    public N endMetadataServiceOptions() {
      return and();
    }
    
  
  }
  public class PlacementNested<N> extends PlacementFluent<PlacementNested<N>> implements Nested<N>{
    PlacementNested(Placement item) {
      this.builder = new PlacementBuilder(this, item);
    }
    PlacementBuilder builder;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.withPlacement(builder.build());
    }
    
    public N endPlacement() {
      return and();
    }
    
  
  }
  public class SecurityGroupsNested<N> extends AWSResourceReferenceFluent<SecurityGroupsNested<N>> implements Nested<N>{
    SecurityGroupsNested(int index,AWSResourceReference item) {
      this.index = index;
      this.builder = new AWSResourceReferenceBuilder(this, item);
    }
    AWSResourceReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.setToSecurityGroups(index,builder.build());
    }
    
    public N endSecurityGroup() {
      return and();
    }
    
  
  }
  public class SpotMarketOptionsNested<N> extends SpotMarketOptionsFluent<SpotMarketOptionsNested<N>> implements Nested<N>{
    SpotMarketOptionsNested(SpotMarketOptions item) {
      this.builder = new SpotMarketOptionsBuilder(this, item);
    }
    SpotMarketOptionsBuilder builder;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.withSpotMarketOptions(builder.build());
    }
    
    public N endSpotMarketOptions() {
      return and();
    }
    
  
  }
  public class SubnetNested<N> extends AWSResourceReferenceFluent<SubnetNested<N>> implements Nested<N>{
    SubnetNested(AWSResourceReference item) {
      this.builder = new AWSResourceReferenceBuilder(this, item);
    }
    AWSResourceReferenceBuilder builder;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.withSubnet(builder.build());
    }
    
    public N endSubnet() {
      return and();
    }
    
  
  }
  public class TagsNested<N> extends TagSpecificationFluent<TagsNested<N>> implements Nested<N>{
    TagsNested(int index,TagSpecification item) {
      this.index = index;
      this.builder = new TagSpecificationBuilder(this, item);
    }
    TagSpecificationBuilder builder;
    int index;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.setToTags(index,builder.build());
    }
    
    public N endTag() {
      return and();
    }
    
  
  }
  public class UserDataSecretNested<N> extends LocalObjectReferenceFluent<UserDataSecretNested<N>> implements Nested<N>{
    UserDataSecretNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) AWSMachineProviderConfigFluent.this.withUserDataSecret(builder.build());
    }
    
    public N endUserDataSecret() {
      return and();
    }
    
  
  }

}