package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NutanixGPUBuilder extends NutanixGPUFluent<NutanixGPUBuilder> implements VisitableBuilder<NutanixGPU,NutanixGPUBuilder>{
  public NutanixGPUBuilder() {
    this(new NutanixGPU());
  }
  
  public NutanixGPUBuilder(NutanixGPUFluent<?> fluent) {
    this(fluent, new NutanixGPU());
  }
  
  public NutanixGPUBuilder(NutanixGPUFluent<?> fluent,NutanixGPU instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NutanixGPUBuilder(NutanixGPU instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NutanixGPUFluent<?> fluent;
  
  public NutanixGPU build() {
    NutanixGPU buildable = new NutanixGPU(fluent.getDeviceID(),fluent.getName(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}