/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openshift.api.model.machine.v1.NutanixResourceIdentifier;
import io.fabric8.openshift.api.model.machine.v1.NutanixResourceIdentifierBuilder;
import io.fabric8.openshift.api.model.machine.v1.NutanixResourceIdentifierFluent;
import io.fabric8.openshift.api.model.machine.v1.NutanixVMDisk;
import io.fabric8.openshift.api.model.machine.v1.NutanixVMDiskDeviceProperties;
import io.fabric8.openshift.api.model.machine.v1.NutanixVMDiskDevicePropertiesBuilder;
import io.fabric8.openshift.api.model.machine.v1.NutanixVMDiskDevicePropertiesFluent;
import io.fabric8.openshift.api.model.machine.v1.NutanixVMStorageConfig;
import io.fabric8.openshift.api.model.machine.v1.NutanixVMStorageConfigBuilder;
import io.fabric8.openshift.api.model.machine.v1.NutanixVMStorageConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NutanixVMDiskFluent<A extends NutanixVMDiskFluent<A>>
extends BaseFluent<A> {
    private NutanixResourceIdentifierBuilder dataSource;
    private NutanixVMDiskDevicePropertiesBuilder deviceProperties;
    private Quantity diskSize;
    private NutanixVMStorageConfigBuilder storageConfig;
    private Map<String, Object> additionalProperties;

    public NutanixVMDiskFluent() {
    }

    public NutanixVMDiskFluent(NutanixVMDisk instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NutanixVMDisk instance) {
        NutanixVMDisk nutanixVMDisk = instance = instance != null ? instance : new NutanixVMDisk();
        if (instance != null) {
            this.withDataSource(instance.getDataSource());
            this.withDeviceProperties(instance.getDeviceProperties());
            this.withDiskSize(instance.getDiskSize());
            this.withStorageConfig(instance.getStorageConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NutanixResourceIdentifier buildDataSource() {
        return this.dataSource != null ? this.dataSource.build() : null;
    }

    public A withDataSource(NutanixResourceIdentifier dataSource) {
        this._visitables.remove((Object)"dataSource");
        if (dataSource != null) {
            this.dataSource = new NutanixResourceIdentifierBuilder(dataSource);
            this._visitables.get((Object)"dataSource").add(this.dataSource);
        } else {
            this.dataSource = null;
            this._visitables.get((Object)"dataSource").remove((Object)this.dataSource);
        }
        return (A)((Object)this);
    }

    public boolean hasDataSource() {
        return this.dataSource != null;
    }

    public A withNewDataSource(String name, String type, String uuid) {
        return this.withDataSource(new NutanixResourceIdentifier(name, type, uuid));
    }

    public DataSourceNested<A> withNewDataSource() {
        return new DataSourceNested(null);
    }

    public DataSourceNested<A> withNewDataSourceLike(NutanixResourceIdentifier item) {
        return new DataSourceNested(item);
    }

    public DataSourceNested<A> editDataSource() {
        return this.withNewDataSourceLike(Optional.ofNullable(this.buildDataSource()).orElse(null));
    }

    public DataSourceNested<A> editOrNewDataSource() {
        return this.withNewDataSourceLike(Optional.ofNullable(this.buildDataSource()).orElse(new NutanixResourceIdentifierBuilder().build()));
    }

    public DataSourceNested<A> editOrNewDataSourceLike(NutanixResourceIdentifier item) {
        return this.withNewDataSourceLike(Optional.ofNullable(this.buildDataSource()).orElse(item));
    }

    public NutanixVMDiskDeviceProperties buildDeviceProperties() {
        return this.deviceProperties != null ? this.deviceProperties.build() : null;
    }

    public A withDeviceProperties(NutanixVMDiskDeviceProperties deviceProperties) {
        this._visitables.remove((Object)"deviceProperties");
        if (deviceProperties != null) {
            this.deviceProperties = new NutanixVMDiskDevicePropertiesBuilder(deviceProperties);
            this._visitables.get((Object)"deviceProperties").add(this.deviceProperties);
        } else {
            this.deviceProperties = null;
            this._visitables.get((Object)"deviceProperties").remove((Object)this.deviceProperties);
        }
        return (A)((Object)this);
    }

    public boolean hasDeviceProperties() {
        return this.deviceProperties != null;
    }

    public A withNewDeviceProperties(String adapterType, Integer deviceIndex, String deviceType) {
        return this.withDeviceProperties(new NutanixVMDiskDeviceProperties(adapterType, deviceIndex, deviceType));
    }

    public DevicePropertiesNested<A> withNewDeviceProperties() {
        return new DevicePropertiesNested(null);
    }

    public DevicePropertiesNested<A> withNewDevicePropertiesLike(NutanixVMDiskDeviceProperties item) {
        return new DevicePropertiesNested(item);
    }

    public DevicePropertiesNested<A> editDeviceProperties() {
        return this.withNewDevicePropertiesLike(Optional.ofNullable(this.buildDeviceProperties()).orElse(null));
    }

    public DevicePropertiesNested<A> editOrNewDeviceProperties() {
        return this.withNewDevicePropertiesLike(Optional.ofNullable(this.buildDeviceProperties()).orElse(new NutanixVMDiskDevicePropertiesBuilder().build()));
    }

    public DevicePropertiesNested<A> editOrNewDevicePropertiesLike(NutanixVMDiskDeviceProperties item) {
        return this.withNewDevicePropertiesLike(Optional.ofNullable(this.buildDeviceProperties()).orElse(item));
    }

    public Quantity getDiskSize() {
        return this.diskSize;
    }

    public A withDiskSize(Quantity diskSize) {
        this.diskSize = diskSize;
        return (A)((Object)this);
    }

    public boolean hasDiskSize() {
        return this.diskSize != null;
    }

    public A withNewDiskSize(String amount, String format) {
        return this.withDiskSize(new Quantity(amount, format));
    }

    public A withNewDiskSize(String amount) {
        return this.withDiskSize(new Quantity(amount));
    }

    public NutanixVMStorageConfig buildStorageConfig() {
        return this.storageConfig != null ? this.storageConfig.build() : null;
    }

    public A withStorageConfig(NutanixVMStorageConfig storageConfig) {
        this._visitables.remove((Object)"storageConfig");
        if (storageConfig != null) {
            this.storageConfig = new NutanixVMStorageConfigBuilder(storageConfig);
            this._visitables.get((Object)"storageConfig").add(this.storageConfig);
        } else {
            this.storageConfig = null;
            this._visitables.get((Object)"storageConfig").remove((Object)this.storageConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasStorageConfig() {
        return this.storageConfig != null;
    }

    public StorageConfigNested<A> withNewStorageConfig() {
        return new StorageConfigNested(null);
    }

    public StorageConfigNested<A> withNewStorageConfigLike(NutanixVMStorageConfig item) {
        return new StorageConfigNested(item);
    }

    public StorageConfigNested<A> editStorageConfig() {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(null));
    }

    public StorageConfigNested<A> editOrNewStorageConfig() {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(new NutanixVMStorageConfigBuilder().build()));
    }

    public StorageConfigNested<A> editOrNewStorageConfigLike(NutanixVMStorageConfig item) {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NutanixVMDiskFluent that = (NutanixVMDiskFluent)((Object)o);
        if (!Objects.equals((Object)this.dataSource, (Object)that.dataSource)) {
            return false;
        }
        if (!Objects.equals((Object)this.deviceProperties, (Object)that.deviceProperties)) {
            return false;
        }
        if (!Objects.equals(this.diskSize, that.diskSize)) {
            return false;
        }
        if (!Objects.equals((Object)this.storageConfig, (Object)that.storageConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataSource, this.deviceProperties, this.diskSize, this.storageConfig, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dataSource != null) {
            sb.append("dataSource:");
            sb.append(this.dataSource + ",");
        }
        if (this.deviceProperties != null) {
            sb.append("deviceProperties:");
            sb.append(this.deviceProperties + ",");
        }
        if (this.diskSize != null) {
            sb.append("diskSize:");
            sb.append(this.diskSize + ",");
        }
        if (this.storageConfig != null) {
            sb.append("storageConfig:");
            sb.append(this.storageConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StorageConfigNested<N>
    extends NutanixVMStorageConfigFluent<StorageConfigNested<N>>
    implements Nested<N> {
        NutanixVMStorageConfigBuilder builder;

        StorageConfigNested(NutanixVMStorageConfig item) {
            this.builder = new NutanixVMStorageConfigBuilder(this, item);
        }

        public N and() {
            return (N)NutanixVMDiskFluent.this.withStorageConfig(this.builder.build());
        }

        public N endStorageConfig() {
            return this.and();
        }
    }

    public class DevicePropertiesNested<N>
    extends NutanixVMDiskDevicePropertiesFluent<DevicePropertiesNested<N>>
    implements Nested<N> {
        NutanixVMDiskDevicePropertiesBuilder builder;

        DevicePropertiesNested(NutanixVMDiskDeviceProperties item) {
            this.builder = new NutanixVMDiskDevicePropertiesBuilder(this, item);
        }

        public N and() {
            return (N)NutanixVMDiskFluent.this.withDeviceProperties(this.builder.build());
        }

        public N endDeviceProperties() {
            return this.and();
        }
    }

    public class DataSourceNested<N>
    extends NutanixResourceIdentifierFluent<DataSourceNested<N>>
    implements Nested<N> {
        NutanixResourceIdentifierBuilder builder;

        DataSourceNested(NutanixResourceIdentifier item) {
            this.builder = new NutanixResourceIdentifierBuilder(this, item);
        }

        public N and() {
            return (N)NutanixVMDiskFluent.this.withDataSource(this.builder.build());
        }

        public N endDataSource() {
            return this.and();
        }
    }
}

