package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineSetListBuilder extends MachineSetListFluentImpl<MachineSetListBuilder> implements VisitableBuilder<MachineSetList,MachineSetListBuilder>{
  public MachineSetListBuilder() {
    this(false);
  }
  public MachineSetListBuilder(Boolean validationEnabled) {
    this(new MachineSetList(), validationEnabled);
  }
  public MachineSetListBuilder(MachineSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineSetListBuilder(MachineSetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineSetList(), validationEnabled);
  }
  public MachineSetListBuilder(MachineSetListFluent<?> fluent,MachineSetList instance) {
    this(fluent, instance, false);
  }
  public MachineSetListBuilder(MachineSetListFluent<?> fluent,MachineSetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineSetListBuilder(MachineSetList instance) {
    this(instance,false);
  }
  public MachineSetListBuilder(MachineSetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineSetListFluent<?> fluent;
  Boolean validationEnabled;
  public MachineSetList build() {
    MachineSetList buildable = new MachineSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}