package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachineHealthCheckSpecFluentImpl<A extends MachineHealthCheckSpecFluent<A>> extends BaseFluent<A> implements MachineHealthCheckSpecFluent<A>{
  public MachineHealthCheckSpecFluentImpl() {
  }
  public MachineHealthCheckSpecFluentImpl(MachineHealthCheckSpec instance) {
    if (instance != null) {
      this.withMaxUnhealthy(instance.getMaxUnhealthy());
      this.withNodeStartupTimeout(instance.getNodeStartupTimeout());
      this.withRemediationTemplate(instance.getRemediationTemplate());
      this.withSelector(instance.getSelector());
      this.withUnhealthyConditions(instance.getUnhealthyConditions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private IntOrStringBuilder maxUnhealthy;
  private Duration nodeStartupTimeout;
  private ObjectReferenceBuilder remediationTemplate;
  private LabelSelectorBuilder selector;
  private ArrayList<UnhealthyConditionBuilder> unhealthyConditions = new ArrayList<UnhealthyConditionBuilder>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildMaxUnhealthy instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getMaxUnhealthy() {
    return this.maxUnhealthy!=null ?this.maxUnhealthy.build():null;
  }
  public IntOrString buildMaxUnhealthy() {
    return this.maxUnhealthy!=null ?this.maxUnhealthy.build():null;
  }
  public A withMaxUnhealthy(IntOrString maxUnhealthy) {
    _visitables.get("maxUnhealthy").remove(this.maxUnhealthy);
    if (maxUnhealthy!=null){ this.maxUnhealthy= new IntOrStringBuilder(maxUnhealthy); _visitables.get("maxUnhealthy").add(this.maxUnhealthy);} else { this.maxUnhealthy = null; _visitables.get("maxUnhealthy").remove(this.maxUnhealthy); } return (A) this;
  }
  public Boolean hasMaxUnhealthy() {
    return this.maxUnhealthy != null;
  }
  public A withNewMaxUnhealthy(Object value) {
    return (A)withMaxUnhealthy(new IntOrString(value));
  }
  public MachineHealthCheckSpecFluentImpl.MaxUnhealthyNested<A> withNewMaxUnhealthy() {
    return new MachineHealthCheckSpecFluentImpl.MaxUnhealthyNestedImpl();
  }
  public MachineHealthCheckSpecFluentImpl.MaxUnhealthyNested<A> withNewMaxUnhealthyLike(IntOrString item) {
    return new MachineHealthCheckSpecFluentImpl.MaxUnhealthyNestedImpl(item);
  }
  public MachineHealthCheckSpecFluentImpl.MaxUnhealthyNested<A> editMaxUnhealthy() {
    return withNewMaxUnhealthyLike(getMaxUnhealthy());
  }
  public MachineHealthCheckSpecFluentImpl.MaxUnhealthyNested<A> editOrNewMaxUnhealthy() {
    return withNewMaxUnhealthyLike(getMaxUnhealthy() != null ? getMaxUnhealthy(): new IntOrStringBuilder().build());
  }
  public MachineHealthCheckSpecFluentImpl.MaxUnhealthyNested<A> editOrNewMaxUnhealthyLike(IntOrString item) {
    return withNewMaxUnhealthyLike(getMaxUnhealthy() != null ? getMaxUnhealthy(): item);
  }
  public Duration getNodeStartupTimeout() {
    return this.nodeStartupTimeout;
  }
  public A withNodeStartupTimeout(Duration nodeStartupTimeout) {
    this.nodeStartupTimeout=nodeStartupTimeout; return (A) this;
  }
  public Boolean hasNodeStartupTimeout() {
    return this.nodeStartupTimeout != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRemediationTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getRemediationTemplate() {
    return this.remediationTemplate!=null ?this.remediationTemplate.build():null;
  }
  public ObjectReference buildRemediationTemplate() {
    return this.remediationTemplate!=null ?this.remediationTemplate.build():null;
  }
  public A withRemediationTemplate(ObjectReference remediationTemplate) {
    _visitables.get("remediationTemplate").remove(this.remediationTemplate);
    if (remediationTemplate!=null){ this.remediationTemplate= new ObjectReferenceBuilder(remediationTemplate); _visitables.get("remediationTemplate").add(this.remediationTemplate);} else { this.remediationTemplate = null; _visitables.get("remediationTemplate").remove(this.remediationTemplate); } return (A) this;
  }
  public Boolean hasRemediationTemplate() {
    return this.remediationTemplate != null;
  }
  public MachineHealthCheckSpecFluentImpl.RemediationTemplateNested<A> withNewRemediationTemplate() {
    return new MachineHealthCheckSpecFluentImpl.RemediationTemplateNestedImpl();
  }
  public MachineHealthCheckSpecFluentImpl.RemediationTemplateNested<A> withNewRemediationTemplateLike(ObjectReference item) {
    return new MachineHealthCheckSpecFluentImpl.RemediationTemplateNestedImpl(item);
  }
  public MachineHealthCheckSpecFluentImpl.RemediationTemplateNested<A> editRemediationTemplate() {
    return withNewRemediationTemplateLike(getRemediationTemplate());
  }
  public MachineHealthCheckSpecFluentImpl.RemediationTemplateNested<A> editOrNewRemediationTemplate() {
    return withNewRemediationTemplateLike(getRemediationTemplate() != null ? getRemediationTemplate(): new ObjectReferenceBuilder().build());
  }
  public MachineHealthCheckSpecFluentImpl.RemediationTemplateNested<A> editOrNewRemediationTemplateLike(ObjectReference item) {
    return withNewRemediationTemplateLike(getRemediationTemplate() != null ? getRemediationTemplate(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public MachineHealthCheckSpecFluentImpl.SelectorNested<A> withNewSelector() {
    return new MachineHealthCheckSpecFluentImpl.SelectorNestedImpl();
  }
  public MachineHealthCheckSpecFluentImpl.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new MachineHealthCheckSpecFluentImpl.SelectorNestedImpl(item);
  }
  public MachineHealthCheckSpecFluentImpl.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public MachineHealthCheckSpecFluentImpl.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public MachineHealthCheckSpecFluentImpl.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public A addToUnhealthyConditions(int index,UnhealthyCondition item) {
    if (this.unhealthyConditions == null) {this.unhealthyConditions = new ArrayList<UnhealthyConditionBuilder>();}
    UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);
    if (index < 0 || index >= unhealthyConditions.size()) { _visitables.get("unhealthyConditions").add(builder); unhealthyConditions.add(builder); } else { _visitables.get("unhealthyConditions").add(index, builder); unhealthyConditions.add(index, builder);}
    return (A)this;
  }
  public A setToUnhealthyConditions(int index,UnhealthyCondition item) {
    if (this.unhealthyConditions == null) {this.unhealthyConditions = new ArrayList<UnhealthyConditionBuilder>();}
    UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);
    if (index < 0 || index >= unhealthyConditions.size()) { _visitables.get("unhealthyConditions").add(builder); unhealthyConditions.add(builder); } else { _visitables.get("unhealthyConditions").set(index, builder); unhealthyConditions.set(index, builder);}
    return (A)this;
  }
  public A addToUnhealthyConditions(io.fabric8.openshift.api.model.machine.v1beta1.UnhealthyCondition... items) {
    if (this.unhealthyConditions == null) {this.unhealthyConditions = new ArrayList<UnhealthyConditionBuilder>();}
    for (UnhealthyCondition item : items) {UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);_visitables.get("unhealthyConditions").add(builder);this.unhealthyConditions.add(builder);} return (A)this;
  }
  public A addAllToUnhealthyConditions(Collection<UnhealthyCondition> items) {
    if (this.unhealthyConditions == null) {this.unhealthyConditions = new ArrayList<UnhealthyConditionBuilder>();}
    for (UnhealthyCondition item : items) {UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);_visitables.get("unhealthyConditions").add(builder);this.unhealthyConditions.add(builder);} return (A)this;
  }
  public A removeFromUnhealthyConditions(io.fabric8.openshift.api.model.machine.v1beta1.UnhealthyCondition... items) {
    for (UnhealthyCondition item : items) {UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);_visitables.get("unhealthyConditions").remove(builder);if (this.unhealthyConditions != null) {this.unhealthyConditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromUnhealthyConditions(Collection<UnhealthyCondition> items) {
    for (UnhealthyCondition item : items) {UnhealthyConditionBuilder builder = new UnhealthyConditionBuilder(item);_visitables.get("unhealthyConditions").remove(builder);if (this.unhealthyConditions != null) {this.unhealthyConditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromUnhealthyConditions(Predicate<UnhealthyConditionBuilder> predicate) {
    if (unhealthyConditions == null) return (A) this;
    final Iterator<UnhealthyConditionBuilder> each = unhealthyConditions.iterator();
    final List visitables = _visitables.get("unhealthyConditions");
    while (each.hasNext()) {
      UnhealthyConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildUnhealthyConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<UnhealthyCondition> getUnhealthyConditions() {
    return unhealthyConditions != null ? build(unhealthyConditions) : null;
  }
  public List<UnhealthyCondition> buildUnhealthyConditions() {
    return unhealthyConditions != null ? build(unhealthyConditions) : null;
  }
  public UnhealthyCondition buildUnhealthyCondition(int index) {
    return this.unhealthyConditions.get(index).build();
  }
  public UnhealthyCondition buildFirstUnhealthyCondition() {
    return this.unhealthyConditions.get(0).build();
  }
  public UnhealthyCondition buildLastUnhealthyCondition() {
    return this.unhealthyConditions.get(unhealthyConditions.size() - 1).build();
  }
  public UnhealthyCondition buildMatchingUnhealthyCondition(Predicate<UnhealthyConditionBuilder> predicate) {
    for (UnhealthyConditionBuilder item: unhealthyConditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingUnhealthyCondition(Predicate<UnhealthyConditionBuilder> predicate) {
    for (UnhealthyConditionBuilder item: unhealthyConditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUnhealthyConditions(List<UnhealthyCondition> unhealthyConditions) {
    if (this.unhealthyConditions != null) { _visitables.get("unhealthyConditions").clear();}
    if (unhealthyConditions != null) {this.unhealthyConditions = new ArrayList(); for (UnhealthyCondition item : unhealthyConditions){this.addToUnhealthyConditions(item);}} else { this.unhealthyConditions = null;} return (A) this;
  }
  public A withUnhealthyConditions(io.fabric8.openshift.api.model.machine.v1beta1.UnhealthyCondition... unhealthyConditions) {
    if (this.unhealthyConditions != null) {this.unhealthyConditions.clear(); _visitables.remove("unhealthyConditions"); }
    if (unhealthyConditions != null) {for (UnhealthyCondition item :unhealthyConditions){ this.addToUnhealthyConditions(item);}} return (A) this;
  }
  public Boolean hasUnhealthyConditions() {
    return unhealthyConditions != null && !unhealthyConditions.isEmpty();
  }
  public MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNested<A> addNewUnhealthyCondition() {
    return new MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNestedImpl();
  }
  public MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNested<A> addNewUnhealthyConditionLike(UnhealthyCondition item) {
    return new MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNestedImpl(-1, item);
  }
  public MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNested<A> setNewUnhealthyConditionLike(int index,UnhealthyCondition item) {
    return new MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNestedImpl(index, item);
  }
  public MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNested<A> editUnhealthyCondition(int index) {
    if (unhealthyConditions.size() <= index) throw new RuntimeException("Can't edit unhealthyConditions. Index exceeds size.");
    return setNewUnhealthyConditionLike(index, buildUnhealthyCondition(index));
  }
  public MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNested<A> editFirstUnhealthyCondition() {
    if (unhealthyConditions.size() == 0) throw new RuntimeException("Can't edit first unhealthyConditions. The list is empty.");
    return setNewUnhealthyConditionLike(0, buildUnhealthyCondition(0));
  }
  public MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNested<A> editLastUnhealthyCondition() {
    int index = unhealthyConditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last unhealthyConditions. The list is empty.");
    return setNewUnhealthyConditionLike(index, buildUnhealthyCondition(index));
  }
  public MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNested<A> editMatchingUnhealthyCondition(Predicate<UnhealthyConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<unhealthyConditions.size();i++) { 
    if (predicate.test(unhealthyConditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching unhealthyConditions. No match found.");
    return setNewUnhealthyConditionLike(index, buildUnhealthyCondition(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineHealthCheckSpecFluentImpl that = (MachineHealthCheckSpecFluentImpl) o;
    if (!java.util.Objects.equals(maxUnhealthy, that.maxUnhealthy)) return false;

    if (!java.util.Objects.equals(nodeStartupTimeout, that.nodeStartupTimeout)) return false;

    if (!java.util.Objects.equals(remediationTemplate, that.remediationTemplate)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(unhealthyConditions, that.unhealthyConditions)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(maxUnhealthy,  nodeStartupTimeout,  remediationTemplate,  selector,  unhealthyConditions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (maxUnhealthy != null) { sb.append("maxUnhealthy:"); sb.append(maxUnhealthy + ","); }
    if (nodeStartupTimeout != null) { sb.append("nodeStartupTimeout:"); sb.append(nodeStartupTimeout + ","); }
    if (remediationTemplate != null) { sb.append("remediationTemplate:"); sb.append(remediationTemplate + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (unhealthyConditions != null) { sb.append("unhealthyConditions:"); sb.append(unhealthyConditions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MaxUnhealthyNestedImpl<N> extends IntOrStringFluentImpl<MachineHealthCheckSpecFluentImpl.MaxUnhealthyNested<N>> implements MachineHealthCheckSpecFluentImpl.MaxUnhealthyNested<N>,Nested<N>{
    MaxUnhealthyNestedImpl(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    MaxUnhealthyNestedImpl() {
      this.builder = new IntOrStringBuilder(this);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) MachineHealthCheckSpecFluentImpl.this.withMaxUnhealthy(builder.build());
    }
    public N endMaxUnhealthy() {
      return and();
    }
    
  }
  class RemediationTemplateNestedImpl<N> extends ObjectReferenceFluentImpl<MachineHealthCheckSpecFluentImpl.RemediationTemplateNested<N>> implements MachineHealthCheckSpecFluentImpl.RemediationTemplateNested<N>,Nested<N>{
    RemediationTemplateNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    RemediationTemplateNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) MachineHealthCheckSpecFluentImpl.this.withRemediationTemplate(builder.build());
    }
    public N endRemediationTemplate() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<MachineHealthCheckSpecFluentImpl.SelectorNested<N>> implements MachineHealthCheckSpecFluentImpl.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) MachineHealthCheckSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class UnhealthyConditionsNestedImpl<N> extends UnhealthyConditionFluentImpl<MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNested<N>> implements MachineHealthCheckSpecFluentImpl.UnhealthyConditionsNested<N>,Nested<N>{
    UnhealthyConditionsNestedImpl(int index,UnhealthyCondition item) {
      this.index = index;
      this.builder = new UnhealthyConditionBuilder(this, item);
    }
    UnhealthyConditionsNestedImpl() {
      this.index = -1;
      this.builder = new UnhealthyConditionBuilder(this);
    }
    UnhealthyConditionBuilder builder;
    int index;
    public N and() {
      return (N) MachineHealthCheckSpecFluentImpl.this.setToUnhealthyConditions(index,builder.build());
    }
    public N endUnhealthyCondition() {
      return and();
    }
    
  }
  
}