package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LastOperationBuilder extends LastOperationFluentImpl<LastOperationBuilder> implements VisitableBuilder<LastOperation,LastOperationBuilder>{
  public LastOperationBuilder() {
    this(false);
  }
  public LastOperationBuilder(Boolean validationEnabled) {
    this(new LastOperation(), validationEnabled);
  }
  public LastOperationBuilder(LastOperationFluent<?> fluent) {
    this(fluent, false);
  }
  public LastOperationBuilder(LastOperationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LastOperation(), validationEnabled);
  }
  public LastOperationBuilder(LastOperationFluent<?> fluent,LastOperation instance) {
    this(fluent, instance, false);
  }
  public LastOperationBuilder(LastOperationFluent<?> fluent,LastOperation instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withLastUpdated(instance.getLastUpdated());
      fluent.withState(instance.getState());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LastOperationBuilder(LastOperation instance) {
    this(instance,false);
  }
  public LastOperationBuilder(LastOperation instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withLastUpdated(instance.getLastUpdated());
      this.withState(instance.getState());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LastOperationFluent<?> fluent;
  Boolean validationEnabled;
  public LastOperation build() {
    LastOperation buildable = new LastOperation(fluent.getDescription(),fluent.getLastUpdated(),fluent.getState(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}