package io.fabric8.openshift.api.model.machine.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AddressPairBuilder extends AddressPairFluent<AddressPairBuilder> implements VisitableBuilder<AddressPair,AddressPairBuilder>{
  public AddressPairBuilder() {
    this(new AddressPair());
  }
  
  public AddressPairBuilder(AddressPairFluent<?> fluent) {
    this(fluent, new AddressPair());
  }
  
  public AddressPairBuilder(AddressPairFluent<?> fluent,AddressPair instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AddressPairBuilder(AddressPair instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AddressPairFluent<?> fluent;
  
  public AddressPair build() {
    AddressPair buildable = new AddressPair(fluent.getIpAddress(),fluent.getMacAddress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}