package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineHealthCheckBuilder extends MachineHealthCheckFluent<MachineHealthCheckBuilder> implements VisitableBuilder<MachineHealthCheck,MachineHealthCheckBuilder>{
  public MachineHealthCheckBuilder() {
    this(new MachineHealthCheck());
  }
  
  public MachineHealthCheckBuilder(MachineHealthCheckFluent<?> fluent) {
    this(fluent, new MachineHealthCheck());
  }
  
  public MachineHealthCheckBuilder(MachineHealthCheckFluent<?> fluent,MachineHealthCheck instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineHealthCheckBuilder(MachineHealthCheck instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineHealthCheckFluent<?> fluent;
  
  public MachineHealthCheck build() {
    MachineHealthCheck buildable = new MachineHealthCheck(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}