/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.vsphere.v1.Metadata;
import io.fabric8.openshift.api.model.installer.vsphere.v1.VCenters;
import io.fabric8.openshift.api.model.installer.vsphere.v1.VCentersBuilder;
import io.fabric8.openshift.api.model.installer.vsphere.v1.VCentersFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MetadataFluent<A extends MetadataFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String password;
    private String terraformPlatform;
    private String username;
    private String vCenter;
    private ArrayList<VCentersBuilder> vCenters = new ArrayList();

    public MetadataFluent() {
    }

    public MetadataFluent(Metadata instance) {
        this.copyInstance(instance);
    }

    public A addAllToVCenters(Collection<VCenters> items) {
        if (this.vCenters == null) {
            this.vCenters = new ArrayList();
        }
        for (VCenters item : items) {
            VCentersBuilder builder = new VCentersBuilder(item);
            this._visitables.get((Object)"vCenters").add(builder);
            this.vCenters.add(builder);
        }
        return (A)((Object)this);
    }

    public VCentersNested<A> addNewVCenter() {
        return new VCentersNested(-1, null);
    }

    public A addNewVCenter(String password, String username, String vCenter) {
        return this.addToVCenters(new VCenters(password, username, vCenter));
    }

    public VCentersNested<A> addNewVCenterLike(VCenters item) {
        return new VCentersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToVCenters(VCenters ... items) {
        if (this.vCenters == null) {
            this.vCenters = new ArrayList();
        }
        for (VCenters item : items) {
            VCentersBuilder builder = new VCentersBuilder(item);
            this._visitables.get((Object)"vCenters").add(builder);
            this.vCenters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToVCenters(int index, VCenters item) {
        if (this.vCenters == null) {
            this.vCenters = new ArrayList();
        }
        VCentersBuilder builder = new VCentersBuilder(item);
        if (index < 0 || index >= this.vCenters.size()) {
            this._visitables.get((Object)"vCenters").add(builder);
            this.vCenters.add(builder);
        } else {
            this._visitables.get((Object)"vCenters").add(builder);
            this.vCenters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public VCenters buildFirstVCenter() {
        return this.vCenters.get(0).build();
    }

    public VCenters buildLastVCenter() {
        return this.vCenters.get(this.vCenters.size() - 1).build();
    }

    public VCenters buildMatchingVCenter(Predicate<VCentersBuilder> predicate) {
        for (VCentersBuilder item : this.vCenters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public VCenters buildVCenter(int index) {
        return this.vCenters.get(index).build();
    }

    public List<VCenters> buildVCenters() {
        return this.vCenters != null ? MetadataFluent.build(this.vCenters) : null;
    }

    protected void copyInstance(Metadata instance) {
        Metadata metadata = instance = instance != null ? instance : new Metadata();
        if (instance != null) {
            this.withVCenters(instance.getVCenters());
            this.withPassword(instance.getPassword());
            this.withTerraformPlatform(instance.getTerraformPlatform());
            this.withUsername(instance.getUsername());
            this.withVCenter(instance.getVCenter());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public VCentersNested<A> editFirstVCenter() {
        if (this.vCenters.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "vCenters"));
        }
        return this.setNewVCenterLike(0, this.buildVCenter(0));
    }

    public VCentersNested<A> editLastVCenter() {
        int index = this.vCenters.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "vCenters"));
        }
        return this.setNewVCenterLike(index, this.buildVCenter(index));
    }

    public VCentersNested<A> editMatchingVCenter(Predicate<VCentersBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.vCenters.size(); ++i) {
            if (!predicate.test(this.vCenters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "vCenters"));
        }
        return this.setNewVCenterLike(index, this.buildVCenter(index));
    }

    public VCentersNested<A> editVCenter(int index) {
        if (this.vCenters.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "vCenters"));
        }
        return this.setNewVCenterLike(index, this.buildVCenter(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetadataFluent that = (MetadataFluent)((Object)o);
        if (!Objects.equals(this.vCenters, that.vCenters)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (!Objects.equals(this.terraformPlatform, that.terraformPlatform)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        if (!Objects.equals(this.vCenter, that.vCenter)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTerraformPlatform() {
        return this.terraformPlatform;
    }

    public String getUsername() {
        return this.username;
    }

    public String getVCenter() {
        return this.vCenter;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingVCenter(Predicate<VCentersBuilder> predicate) {
        for (VCentersBuilder item : this.vCenters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public boolean hasTerraformPlatform() {
        return this.terraformPlatform != null;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public boolean hasVCenter() {
        return this.vCenter != null;
    }

    public boolean hasVCenters() {
        return this.vCenters != null && !this.vCenters.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.vCenters, this.password, this.terraformPlatform, this.username, this.vCenter, this.additionalProperties);
    }

    public A removeAllFromVCenters(Collection<VCenters> items) {
        if (this.vCenters == null) {
            return (A)((Object)this);
        }
        for (VCenters item : items) {
            VCentersBuilder builder = new VCentersBuilder(item);
            this._visitables.get((Object)"vCenters").remove((Object)builder);
            this.vCenters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromVCenters(VCenters ... items) {
        if (this.vCenters == null) {
            return (A)((Object)this);
        }
        for (VCenters item : items) {
            VCentersBuilder builder = new VCentersBuilder(item);
            this._visitables.get((Object)"vCenters").remove((Object)builder);
            this.vCenters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVCenters(Predicate<VCentersBuilder> predicate) {
        if (this.vCenters == null) {
            return (A)((Object)this);
        }
        Iterator<VCentersBuilder> each = this.vCenters.iterator();
        List visitables = this._visitables.get((Object)"vCenters");
        while (each.hasNext()) {
            VCentersBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public VCentersNested<A> setNewVCenterLike(int index, VCenters item) {
        return new VCentersNested(index, item);
    }

    public A setToVCenters(int index, VCenters item) {
        if (this.vCenters == null) {
            this.vCenters = new ArrayList();
        }
        VCentersBuilder builder = new VCentersBuilder(item);
        if (index < 0 || index >= this.vCenters.size()) {
            this._visitables.get((Object)"vCenters").add(builder);
            this.vCenters.add(builder);
        } else {
            this._visitables.get((Object)"vCenters").add(builder);
            this.vCenters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.vCenters != null && !this.vCenters.isEmpty()) {
            sb.append("vCenters:");
            sb.append(this.vCenters);
            sb.append(",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password);
            sb.append(",");
        }
        if (this.terraformPlatform != null) {
            sb.append("terraformPlatform:");
            sb.append(this.terraformPlatform);
            sb.append(",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username);
            sb.append(",");
        }
        if (this.vCenter != null) {
            sb.append("vCenter:");
            sb.append(this.vCenter);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withPassword(String password) {
        this.password = password;
        return (A)((Object)this);
    }

    public A withTerraformPlatform(String terraformPlatform) {
        this.terraformPlatform = terraformPlatform;
        return (A)((Object)this);
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)((Object)this);
    }

    public A withVCenter(String vCenter) {
        this.vCenter = vCenter;
        return (A)((Object)this);
    }

    public A withVCenters(List<VCenters> vCenters) {
        if (this.vCenters != null) {
            this._visitables.get((Object)"vCenters").clear();
        }
        if (vCenters != null) {
            this.vCenters = new ArrayList();
            for (VCenters item : vCenters) {
                this.addToVCenters(item);
            }
        } else {
            this.vCenters = null;
        }
        return (A)((Object)this);
    }

    public A withVCenters(VCenters ... vCenters) {
        if (this.vCenters != null) {
            this.vCenters.clear();
            this._visitables.remove((Object)"vCenters");
        }
        if (vCenters != null) {
            for (VCenters item : vCenters) {
                this.addToVCenters(item);
            }
        }
        return (A)((Object)this);
    }

    public class VCentersNested<N>
    extends VCentersFluent<VCentersNested<N>>
    implements Nested<N> {
        VCentersBuilder builder;
        int index;

        VCentersNested(int index, VCenters item) {
            this.index = index;
            this.builder = new VCentersBuilder(this, item);
        }

        public N and() {
            return (N)MetadataFluent.this.setToVCenters(this.index, this.builder.build());
        }

        public N endVCenter() {
            return this.and();
        }
    }
}

