/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.vsphere.v1.FailureDomain;
import io.fabric8.openshift.api.model.installer.vsphere.v1.Topology;
import io.fabric8.openshift.api.model.installer.vsphere.v1.TopologyBuilder;
import io.fabric8.openshift.api.model.installer.vsphere.v1.TopologyFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FailureDomainFluent<A extends FailureDomainFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String name;
    private String region;
    private String regionType;
    private String server;
    private TopologyBuilder topology;
    private String zone;
    private String zoneType;

    public FailureDomainFluent() {
    }

    public FailureDomainFluent(FailureDomain instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public Topology buildTopology() {
        return this.topology != null ? this.topology.build() : null;
    }

    protected void copyInstance(FailureDomain instance) {
        FailureDomain failureDomain = instance = instance != null ? instance : new FailureDomain();
        if (instance != null) {
            this.withName(instance.getName());
            this.withRegion(instance.getRegion());
            this.withRegionType(instance.getRegionType());
            this.withServer(instance.getServer());
            this.withTopology(instance.getTopology());
            this.withZone(instance.getZone());
            this.withZoneType(instance.getZoneType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TopologyNested<A> editOrNewTopology() {
        return this.withNewTopologyLike(Optional.ofNullable(this.buildTopology()).orElse(new TopologyBuilder().build()));
    }

    public TopologyNested<A> editOrNewTopologyLike(Topology item) {
        return this.withNewTopologyLike(Optional.ofNullable(this.buildTopology()).orElse(item));
    }

    public TopologyNested<A> editTopology() {
        return this.withNewTopologyLike(Optional.ofNullable(this.buildTopology()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FailureDomainFluent that = (FailureDomainFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.regionType, that.regionType)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals((Object)this.topology, (Object)that.topology)) {
            return false;
        }
        if (!Objects.equals(this.zone, that.zone)) {
            return false;
        }
        if (!Objects.equals(this.zoneType, that.zoneType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRegionType() {
        return this.regionType;
    }

    public String getServer() {
        return this.server;
    }

    public String getZone() {
        return this.zone;
    }

    public String getZoneType() {
        return this.zoneType;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public boolean hasRegionType() {
        return this.regionType != null;
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public boolean hasTopology() {
        return this.topology != null;
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public boolean hasZoneType() {
        return this.zoneType != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.region, this.regionType, this.server, this.topology, this.zone, this.zoneType, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region);
            sb.append(",");
        }
        if (this.regionType != null) {
            sb.append("regionType:");
            sb.append(this.regionType);
            sb.append(",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server);
            sb.append(",");
        }
        if (this.topology != null) {
            sb.append("topology:");
            sb.append((Object)this.topology);
            sb.append(",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone);
            sb.append(",");
        }
        if (this.zoneType != null) {
            sb.append("zoneType:");
            sb.append(this.zoneType);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public TopologyNested<A> withNewTopology() {
        return new TopologyNested(null);
    }

    public TopologyNested<A> withNewTopologyLike(Topology item) {
        return new TopologyNested(item);
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public A withRegionType(String regionType) {
        this.regionType = regionType;
        return (A)((Object)this);
    }

    public A withServer(String server) {
        this.server = server;
        return (A)((Object)this);
    }

    public A withTopology(Topology topology) {
        this._visitables.remove((Object)"topology");
        if (topology != null) {
            this.topology = new TopologyBuilder(topology);
            this._visitables.get((Object)"topology").add(this.topology);
        } else {
            this.topology = null;
            this._visitables.get((Object)"topology").remove((Object)this.topology);
        }
        return (A)((Object)this);
    }

    public A withZone(String zone) {
        this.zone = zone;
        return (A)((Object)this);
    }

    public A withZoneType(String zoneType) {
        this.zoneType = zoneType;
        return (A)((Object)this);
    }

    public class TopologyNested<N>
    extends TopologyFluent<TopologyNested<N>>
    implements Nested<N> {
        TopologyBuilder builder;

        TopologyNested(Topology item) {
            this.builder = new TopologyBuilder(this, item);
        }

        public N and() {
            return (N)FailureDomainFluent.this.withTopology(this.builder.build());
        }

        public N endTopology() {
            return this.and();
        }
    }
}

