/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.powervs.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpoint;
import io.fabric8.openshift.api.model.installer.powervs.v1.Metadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MetadataFluent<A extends MetadataFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String baseDomain;
    private String cisInstanceCRN;
    private String dnsInstanceCRN;
    private String powerVSResourceGroup;
    private String region;
    private List<PowerVSServiceEndpoint> serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
    private String serviceInstanceGUID;
    private String transitGatewayName;
    private String vpcName;
    private String vpcRegion;
    private String zone;

    public MetadataFluent() {
    }

    public MetadataFluent(Metadata instance) {
        this.copyInstance(instance);
    }

    public A addAllToServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
        }
        for (PowerVSServiceEndpoint item : items) {
            this.serviceEndpoints.add(item);
        }
        return (A)((Object)this);
    }

    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new PowerVSServiceEndpoint(name, url));
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToServiceEndpoints(PowerVSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
        }
        for (PowerVSServiceEndpoint item : items) {
            this.serviceEndpoints.add(item);
        }
        return (A)((Object)this);
    }

    public A addToServiceEndpoints(int index, PowerVSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
        }
        this.serviceEndpoints.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(Metadata instance) {
        Metadata metadata = instance = instance != null ? instance : new Metadata();
        if (instance != null) {
            this.withBaseDomain(instance.getBaseDomain());
            this.withCisInstanceCRN(instance.getCisInstanceCRN());
            this.withDnsInstanceCRN(instance.getDnsInstanceCRN());
            this.withPowerVSResourceGroup(instance.getPowerVSResourceGroup());
            this.withRegion(instance.getRegion());
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withServiceInstanceGUID(instance.getServiceInstanceGUID());
            this.withTransitGatewayName(instance.getTransitGatewayName());
            this.withVpcName(instance.getVpcName());
            this.withVpcRegion(instance.getVpcRegion());
            this.withZone(instance.getZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetadataFluent that = (MetadataFluent)((Object)o);
        if (!Objects.equals(this.baseDomain, that.baseDomain)) {
            return false;
        }
        if (!Objects.equals(this.cisInstanceCRN, that.cisInstanceCRN)) {
            return false;
        }
        if (!Objects.equals(this.dnsInstanceCRN, that.dnsInstanceCRN)) {
            return false;
        }
        if (!Objects.equals(this.powerVSResourceGroup, that.powerVSResourceGroup)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.serviceEndpoints, that.serviceEndpoints)) {
            return false;
        }
        if (!Objects.equals(this.serviceInstanceGUID, that.serviceInstanceGUID)) {
            return false;
        }
        if (!Objects.equals(this.transitGatewayName, that.transitGatewayName)) {
            return false;
        }
        if (!Objects.equals(this.vpcName, that.vpcName)) {
            return false;
        }
        if (!Objects.equals(this.vpcRegion, that.vpcRegion)) {
            return false;
        }
        if (!Objects.equals(this.zone, that.zone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBaseDomain() {
        return this.baseDomain;
    }

    public String getCisInstanceCRN() {
        return this.cisInstanceCRN;
    }

    public String getDnsInstanceCRN() {
        return this.dnsInstanceCRN;
    }

    public PowerVSServiceEndpoint getFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0);
    }

    public PowerVSServiceEndpoint getLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1);
    }

    public PowerVSServiceEndpoint getMatchingServiceEndpoint(Predicate<PowerVSServiceEndpoint> predicate) {
        for (PowerVSServiceEndpoint item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPowerVSResourceGroup() {
        return this.powerVSResourceGroup;
    }

    public String getRegion() {
        return this.region;
    }

    public PowerVSServiceEndpoint getServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index);
    }

    public List<PowerVSServiceEndpoint> getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    public String getServiceInstanceGUID() {
        return this.serviceInstanceGUID;
    }

    public String getTransitGatewayName() {
        return this.transitGatewayName;
    }

    public String getVpcName() {
        return this.vpcName;
    }

    public String getVpcRegion() {
        return this.vpcRegion;
    }

    public String getZone() {
        return this.zone;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    public boolean hasCisInstanceCRN() {
        return this.cisInstanceCRN != null;
    }

    public boolean hasDnsInstanceCRN() {
        return this.dnsInstanceCRN != null;
    }

    public boolean hasMatchingServiceEndpoint(Predicate<PowerVSServiceEndpoint> predicate) {
        for (PowerVSServiceEndpoint item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPowerVSResourceGroup() {
        return this.powerVSResourceGroup != null;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    public boolean hasServiceInstanceGUID() {
        return this.serviceInstanceGUID != null;
    }

    public boolean hasTransitGatewayName() {
        return this.transitGatewayName != null;
    }

    public boolean hasVpcName() {
        return this.vpcName != null;
    }

    public boolean hasVpcRegion() {
        return this.vpcRegion != null;
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public int hashCode() {
        return Objects.hash(this.baseDomain, this.cisInstanceCRN, this.dnsInstanceCRN, this.powerVSResourceGroup, this.region, this.serviceEndpoints, this.serviceInstanceGUID, this.transitGatewayName, this.vpcName, this.vpcRegion, this.zone, this.additionalProperties);
    }

    public A removeAllFromServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        for (PowerVSServiceEndpoint item : items) {
            this.serviceEndpoints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromServiceEndpoints(PowerVSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        for (PowerVSServiceEndpoint item : items) {
            this.serviceEndpoints.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToServiceEndpoints(int index, PowerVSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
        }
        this.serviceEndpoints.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseDomain != null) {
            sb.append("baseDomain:");
            sb.append(this.baseDomain);
            sb.append(",");
        }
        if (this.cisInstanceCRN != null) {
            sb.append("cisInstanceCRN:");
            sb.append(this.cisInstanceCRN);
            sb.append(",");
        }
        if (this.dnsInstanceCRN != null) {
            sb.append("dnsInstanceCRN:");
            sb.append(this.dnsInstanceCRN);
            sb.append(",");
        }
        if (this.powerVSResourceGroup != null) {
            sb.append("powerVSResourceGroup:");
            sb.append(this.powerVSResourceGroup);
            sb.append(",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region);
            sb.append(",");
        }
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(this.serviceEndpoints);
            sb.append(",");
        }
        if (this.serviceInstanceGUID != null) {
            sb.append("serviceInstanceGUID:");
            sb.append(this.serviceInstanceGUID);
            sb.append(",");
        }
        if (this.transitGatewayName != null) {
            sb.append("transitGatewayName:");
            sb.append(this.transitGatewayName);
            sb.append(",");
        }
        if (this.vpcName != null) {
            sb.append("vpcName:");
            sb.append(this.vpcName);
            sb.append(",");
        }
        if (this.vpcRegion != null) {
            sb.append("vpcRegion:");
            sb.append(this.vpcRegion);
            sb.append(",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)((Object)this);
    }

    public A withCisInstanceCRN(String cisInstanceCRN) {
        this.cisInstanceCRN = cisInstanceCRN;
        return (A)((Object)this);
    }

    public A withDnsInstanceCRN(String dnsInstanceCRN) {
        this.dnsInstanceCRN = dnsInstanceCRN;
        return (A)((Object)this);
    }

    public A withPowerVSResourceGroup(String powerVSResourceGroup) {
        this.powerVSResourceGroup = powerVSResourceGroup;
        return (A)((Object)this);
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public A withServiceEndpoints(List<PowerVSServiceEndpoint> serviceEndpoints) {
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
            for (PowerVSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)((Object)this);
    }

    public A withServiceEndpoints(PowerVSServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
            this._visitables.remove((Object)"serviceEndpoints");
        }
        if (serviceEndpoints != null) {
            for (PowerVSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)((Object)this);
    }

    public A withServiceInstanceGUID(String serviceInstanceGUID) {
        this.serviceInstanceGUID = serviceInstanceGUID;
        return (A)((Object)this);
    }

    public A withTransitGatewayName(String transitGatewayName) {
        this.transitGatewayName = transitGatewayName;
        return (A)((Object)this);
    }

    public A withVpcName(String vpcName) {
        this.vpcName = vpcName;
        return (A)((Object)this);
    }

    public A withVpcRegion(String vpcRegion) {
        this.vpcRegion = vpcRegion;
        return (A)((Object)this);
    }

    public A withZone(String zone) {
        this.zone = zone;
        return (A)((Object)this);
    }
}

