/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.powervc.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.installer.powervc.v1.RootVolume;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RootVolumeFluent<A extends RootVolumeFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer size;
    private String type;
    private List<String> types = new ArrayList<String>();
    private List<String> zones = new ArrayList<String>();

    public RootVolumeFluent() {
    }

    public RootVolumeFluent(RootVolume instance) {
        this.copyInstance(instance);
    }

    public A addAllToTypes(Collection<String> items) {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        for (String item : items) {
            this.types.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTypes(String ... items) {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        for (String item : items) {
            this.types.add(item);
        }
        return (A)((Object)this);
    }

    public A addToTypes(int index, String item) {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        this.types.add(index, item);
        return (A)((Object)this);
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)((Object)this);
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(RootVolume instance) {
        RootVolume rootVolume = instance = instance != null ? instance : new RootVolume();
        if (instance != null) {
            this.withSize(instance.getSize());
            this.withType(instance.getType());
            this.withTypes(instance.getTypes());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RootVolumeFluent that = (RootVolumeFluent)((Object)o);
        if (!Objects.equals(this.size, that.size)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.types, that.types)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstType() {
        return this.types.get(0);
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastType() {
        return this.types.get(this.types.size() - 1);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingType(Predicate<String> predicate) {
        for (String item : this.types) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    public String getType(int index) {
        return this.types.get(index);
    }

    public List<String> getTypes() {
        return this.types;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public List<String> getZones() {
        return this.zones;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingType(Predicate<String> predicate) {
        for (String item : this.types) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean hasTypes() {
        return this.types != null && !this.types.isEmpty();
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.size, this.type, this.types, this.zones, this.additionalProperties);
    }

    public A removeAllFromTypes(Collection<String> items) {
        if (this.types == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.types.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTypes(String ... items) {
        if (this.types == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.types.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToTypes(int index, String item) {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        this.types.set(index, item);
        return (A)((Object)this);
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.size != null) {
            sb.append("size:");
            sb.append(this.size);
            sb.append(",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
            sb.append(",");
        }
        if (this.types != null && !this.types.isEmpty()) {
            sb.append("types:");
            sb.append(this.types);
            sb.append(",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(this.zones);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withSize(Integer size) {
        this.size = size;
        return (A)((Object)this);
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public A withTypes(List<String> types) {
        if (types != null) {
            this.types = new ArrayList<String>();
            for (String item : types) {
                this.addToTypes(item);
            }
        } else {
            this.types = null;
        }
        return (A)((Object)this);
    }

    public A withTypes(String ... types) {
        if (this.types != null) {
            this.types.clear();
            this._visitables.remove((Object)"types");
        }
        if (types != null) {
            for (String item : types) {
                this.addToTypes(item);
            }
        }
        return (A)((Object)this);
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)((Object)this);
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove((Object)"zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)((Object)this);
    }
}

