/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.v1.Credential;
import io.fabric8.openshift.api.model.installer.v1.CredentialBuilder;
import io.fabric8.openshift.api.model.installer.v1.CredentialFluent;
import io.fabric8.openshift.api.model.installer.v1.Fencing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FencingFluent<A extends FencingFluent<A>>
extends BaseFluent<A> {
    private ArrayList<CredentialBuilder> credentials = new ArrayList();
    private Map<String, Object> additionalProperties;

    public FencingFluent() {
    }

    public FencingFluent(Fencing instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Fencing instance) {
        Fencing fencing = instance = instance != null ? instance : new Fencing();
        if (instance != null) {
            this.withCredentials(instance.getCredentials());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCredentials(int index, Credential item) {
        if (this.credentials == null) {
            this.credentials = new ArrayList();
        }
        CredentialBuilder builder = new CredentialBuilder(item);
        if (index < 0 || index >= this.credentials.size()) {
            this._visitables.get((Object)"credentials").add(builder);
            this.credentials.add(builder);
        } else {
            this._visitables.get((Object)"credentials").add(builder);
            this.credentials.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCredentials(int index, Credential item) {
        if (this.credentials == null) {
            this.credentials = new ArrayList();
        }
        CredentialBuilder builder = new CredentialBuilder(item);
        if (index < 0 || index >= this.credentials.size()) {
            this._visitables.get((Object)"credentials").add(builder);
            this.credentials.add(builder);
        } else {
            this._visitables.get((Object)"credentials").add(builder);
            this.credentials.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCredentials(Credential ... items) {
        if (this.credentials == null) {
            this.credentials = new ArrayList();
        }
        for (Credential item : items) {
            CredentialBuilder builder = new CredentialBuilder(item);
            this._visitables.get((Object)"credentials").add(builder);
            this.credentials.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToCredentials(Collection<Credential> items) {
        if (this.credentials == null) {
            this.credentials = new ArrayList();
        }
        for (Credential item : items) {
            CredentialBuilder builder = new CredentialBuilder(item);
            this._visitables.get((Object)"credentials").add(builder);
            this.credentials.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCredentials(Credential ... items) {
        if (this.credentials == null) {
            return (A)((Object)this);
        }
        for (Credential item : items) {
            CredentialBuilder builder = new CredentialBuilder(item);
            this._visitables.get((Object)"credentials").remove((Object)builder);
            this.credentials.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCredentials(Collection<Credential> items) {
        if (this.credentials == null) {
            return (A)((Object)this);
        }
        for (Credential item : items) {
            CredentialBuilder builder = new CredentialBuilder(item);
            this._visitables.get((Object)"credentials").remove((Object)builder);
            this.credentials.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCredentials(Predicate<CredentialBuilder> predicate) {
        if (this.credentials == null) {
            return (A)((Object)this);
        }
        Iterator<CredentialBuilder> each = this.credentials.iterator();
        List visitables = this._visitables.get((Object)"credentials");
        while (each.hasNext()) {
            CredentialBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Credential> buildCredentials() {
        return this.credentials != null ? FencingFluent.build(this.credentials) : null;
    }

    public Credential buildCredential(int index) {
        return this.credentials.get(index).build();
    }

    public Credential buildFirstCredential() {
        return this.credentials.get(0).build();
    }

    public Credential buildLastCredential() {
        return this.credentials.get(this.credentials.size() - 1).build();
    }

    public Credential buildMatchingCredential(Predicate<CredentialBuilder> predicate) {
        for (CredentialBuilder item : this.credentials) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCredential(Predicate<CredentialBuilder> predicate) {
        for (CredentialBuilder item : this.credentials) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCredentials(List<Credential> credentials) {
        if (this.credentials != null) {
            this._visitables.get((Object)"credentials").clear();
        }
        if (credentials != null) {
            this.credentials = new ArrayList();
            for (Credential item : credentials) {
                this.addToCredentials(item);
            }
        } else {
            this.credentials = null;
        }
        return (A)((Object)this);
    }

    public A withCredentials(Credential ... credentials) {
        if (this.credentials != null) {
            this.credentials.clear();
            this._visitables.remove((Object)"credentials");
        }
        if (credentials != null) {
            for (Credential item : credentials) {
                this.addToCredentials(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCredentials() {
        return this.credentials != null && !this.credentials.isEmpty();
    }

    public A addNewCredential(String address, String hostName, String password, String username) {
        return this.addToCredentials(new Credential(address, hostName, password, username));
    }

    public CredentialsNested<A> addNewCredential() {
        return new CredentialsNested(-1, null);
    }

    public CredentialsNested<A> addNewCredentialLike(Credential item) {
        return new CredentialsNested(-1, item);
    }

    public CredentialsNested<A> setNewCredentialLike(int index, Credential item) {
        return new CredentialsNested(index, item);
    }

    public CredentialsNested<A> editCredential(int index) {
        if (this.credentials.size() <= index) {
            throw new RuntimeException("Can't edit credentials. Index exceeds size.");
        }
        return this.setNewCredentialLike(index, this.buildCredential(index));
    }

    public CredentialsNested<A> editFirstCredential() {
        if (this.credentials.size() == 0) {
            throw new RuntimeException("Can't edit first credentials. The list is empty.");
        }
        return this.setNewCredentialLike(0, this.buildCredential(0));
    }

    public CredentialsNested<A> editLastCredential() {
        int index = this.credentials.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last credentials. The list is empty.");
        }
        return this.setNewCredentialLike(index, this.buildCredential(index));
    }

    public CredentialsNested<A> editMatchingCredential(Predicate<CredentialBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.credentials.size(); ++i) {
            if (!predicate.test(this.credentials.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching credentials. No match found.");
        }
        return this.setNewCredentialLike(index, this.buildCredential(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FencingFluent that = (FencingFluent)((Object)o);
        if (!Objects.equals(this.credentials, that.credentials)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.credentials != null && !this.credentials.isEmpty()) {
            sb.append("credentials:");
            sb.append(String.valueOf(this.credentials) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CredentialsNested<N>
    extends CredentialFluent<CredentialsNested<N>>
    implements Nested<N> {
        CredentialBuilder builder;
        int index;

        CredentialsNested(int index, Credential item) {
            this.index = index;
            this.builder = new CredentialBuilder(this, item);
        }

        public N and() {
            return (N)FencingFluent.this.setToCredentials(this.index, this.builder.build());
        }

        public N endCredential() {
            return this.and();
        }
    }
}

