package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterQuotaBuilder extends ClusterQuotaFluent<ClusterQuotaBuilder> implements VisitableBuilder<ClusterQuota,ClusterQuotaBuilder>{
  public ClusterQuotaBuilder() {
    this(new ClusterQuota());
  }
  
  public ClusterQuotaBuilder(ClusterQuotaFluent<?> fluent) {
    this(fluent, new ClusterQuota());
  }
  
  public ClusterQuotaBuilder(ClusterQuotaFluent<?> fluent,ClusterQuota instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterQuotaBuilder(ClusterQuota instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterQuotaFluent<?> fluent;
  
  public ClusterQuota build() {
    ClusterQuota buildable = new ClusterQuota(fluent.buildGcp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}