package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.machine.v1.NutanixGPU;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.openshift.api.model.machine.v1.NutanixCategory;
import java.lang.Integer;
import io.fabric8.openshift.api.model.machine.v1.NutanixResourceIdentifier;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  
  public MachinePoolFluent(MachinePool instance) {
    this.copyInstance(instance);
  }
  private String bootType;
  private List<NutanixCategory> categories = new ArrayList<NutanixCategory>();
  private Long coresPerSocket;
  private Long cpus;
  private ArrayList<DataDiskBuilder> dataDisks = new ArrayList<DataDiskBuilder>();
  private List<String> failureDomains = new ArrayList<String>();
  private List<NutanixGPU> gpus = new ArrayList<NutanixGPU>();
  private Long memoryMiB;
  private OSDiskBuilder osDisk;
  private NutanixResourceIdentifier project;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());
    if (instance != null) {
          this.withBootType(instance.getBootType());
          this.withCategories(instance.getCategories());
          this.withCoresPerSocket(instance.getCoresPerSocket());
          this.withCpus(instance.getCpus());
          this.withDataDisks(instance.getDataDisks());
          this.withFailureDomains(instance.getFailureDomains());
          this.withGpus(instance.getGpus());
          this.withMemoryMiB(instance.getMemoryMiB());
          this.withOsDisk(instance.getOsDisk());
          this.withProject(instance.getProject());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBootType() {
    return this.bootType;
  }
  
  public A withBootType(String bootType) {
    this.bootType = bootType;
    return (A) this;
  }
  
  public boolean hasBootType() {
    return this.bootType != null;
  }
  
  public A addToCategories(int index,NutanixCategory item) {
    if (this.categories == null) {this.categories = new ArrayList<NutanixCategory>();}
    this.categories.add(index, item);
    return (A)this;
  }
  
  public A setToCategories(int index,NutanixCategory item) {
    if (this.categories == null) {this.categories = new ArrayList<NutanixCategory>();}
    this.categories.set(index, item); return (A)this;
  }
  
  public A addToCategories(io.fabric8.openshift.api.model.machine.v1.NutanixCategory... items) {
    if (this.categories == null) {this.categories = new ArrayList<NutanixCategory>();}
    for (NutanixCategory item : items) {this.categories.add(item);} return (A)this;
  }
  
  public A addAllToCategories(Collection<NutanixCategory> items) {
    if (this.categories == null) {this.categories = new ArrayList<NutanixCategory>();}
    for (NutanixCategory item : items) {this.categories.add(item);} return (A)this;
  }
  
  public A removeFromCategories(io.fabric8.openshift.api.model.machine.v1.NutanixCategory... items) {
    if (this.categories == null) return (A)this;
    for (NutanixCategory item : items) { this.categories.remove(item);} return (A)this;
  }
  
  public A removeAllFromCategories(Collection<NutanixCategory> items) {
    if (this.categories == null) return (A)this;
    for (NutanixCategory item : items) { this.categories.remove(item);} return (A)this;
  }
  
  public List<NutanixCategory> getCategories() {
    return this.categories;
  }
  
  public NutanixCategory getCategory(int index) {
    return this.categories.get(index);
  }
  
  public NutanixCategory getFirstCategory() {
    return this.categories.get(0);
  }
  
  public NutanixCategory getLastCategory() {
    return this.categories.get(categories.size() - 1);
  }
  
  public NutanixCategory getMatchingCategory(Predicate<NutanixCategory> predicate) {
      for (NutanixCategory item : categories) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCategory(Predicate<NutanixCategory> predicate) {
      for (NutanixCategory item : categories) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCategories(List<NutanixCategory> categories) {
    if (categories != null) {
        this.categories = new ArrayList();
        for (NutanixCategory item : categories) {
          this.addToCategories(item);
        }
    } else {
      this.categories = null;
    }
    return (A) this;
  }
  
  public A withCategories(io.fabric8.openshift.api.model.machine.v1.NutanixCategory... categories) {
    if (this.categories != null) {
        this.categories.clear();
        _visitables.remove("categories");
    }
    if (categories != null) {
      for (NutanixCategory item : categories) {
        this.addToCategories(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCategories() {
    return this.categories != null && !this.categories.isEmpty();
  }
  
  public A addNewCategory(String key,String value) {
    return (A)addToCategories(new NutanixCategory(key, value));
  }
  
  public Long getCoresPerSocket() {
    return this.coresPerSocket;
  }
  
  public A withCoresPerSocket(Long coresPerSocket) {
    this.coresPerSocket = coresPerSocket;
    return (A) this;
  }
  
  public boolean hasCoresPerSocket() {
    return this.coresPerSocket != null;
  }
  
  public Long getCpus() {
    return this.cpus;
  }
  
  public A withCpus(Long cpus) {
    this.cpus = cpus;
    return (A) this;
  }
  
  public boolean hasCpus() {
    return this.cpus != null;
  }
  
  public A addToDataDisks(int index,DataDisk item) {
    if (this.dataDisks == null) {this.dataDisks = new ArrayList<DataDiskBuilder>();}
    DataDiskBuilder builder = new DataDiskBuilder(item);
    if (index < 0 || index >= dataDisks.size()) { _visitables.get("dataDisks").add(builder); dataDisks.add(builder); } else { _visitables.get("dataDisks").add(index, builder); dataDisks.add(index, builder);}
    return (A)this;
  }
  
  public A setToDataDisks(int index,DataDisk item) {
    if (this.dataDisks == null) {this.dataDisks = new ArrayList<DataDiskBuilder>();}
    DataDiskBuilder builder = new DataDiskBuilder(item);
    if (index < 0 || index >= dataDisks.size()) { _visitables.get("dataDisks").add(builder); dataDisks.add(builder); } else { _visitables.get("dataDisks").set(index, builder); dataDisks.set(index, builder);}
    return (A)this;
  }
  
  public A addToDataDisks(io.fabric8.openshift.api.model.installer.nutanix.v1.DataDisk... items) {
    if (this.dataDisks == null) {this.dataDisks = new ArrayList<DataDiskBuilder>();}
    for (DataDisk item : items) {DataDiskBuilder builder = new DataDiskBuilder(item);_visitables.get("dataDisks").add(builder);this.dataDisks.add(builder);} return (A)this;
  }
  
  public A addAllToDataDisks(Collection<DataDisk> items) {
    if (this.dataDisks == null) {this.dataDisks = new ArrayList<DataDiskBuilder>();}
    for (DataDisk item : items) {DataDiskBuilder builder = new DataDiskBuilder(item);_visitables.get("dataDisks").add(builder);this.dataDisks.add(builder);} return (A)this;
  }
  
  public A removeFromDataDisks(io.fabric8.openshift.api.model.installer.nutanix.v1.DataDisk... items) {
    if (this.dataDisks == null) return (A)this;
    for (DataDisk item : items) {DataDiskBuilder builder = new DataDiskBuilder(item);_visitables.get("dataDisks").remove(builder); this.dataDisks.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDataDisks(Collection<DataDisk> items) {
    if (this.dataDisks == null) return (A)this;
    for (DataDisk item : items) {DataDiskBuilder builder = new DataDiskBuilder(item);_visitables.get("dataDisks").remove(builder); this.dataDisks.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDataDisks(Predicate<DataDiskBuilder> predicate) {
    if (dataDisks == null) return (A) this;
    final Iterator<DataDiskBuilder> each = dataDisks.iterator();
    final List visitables = _visitables.get("dataDisks");
    while (each.hasNext()) {
      DataDiskBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DataDisk> buildDataDisks() {
    return this.dataDisks != null ? build(dataDisks) : null;
  }
  
  public DataDisk buildDataDisk(int index) {
    return this.dataDisks.get(index).build();
  }
  
  public DataDisk buildFirstDataDisk() {
    return this.dataDisks.get(0).build();
  }
  
  public DataDisk buildLastDataDisk() {
    return this.dataDisks.get(dataDisks.size() - 1).build();
  }
  
  public DataDisk buildMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
      for (DataDiskBuilder item : dataDisks) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
      for (DataDiskBuilder item : dataDisks) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDataDisks(List<DataDisk> dataDisks) {
    if (this.dataDisks != null) {
      this._visitables.get("dataDisks").clear();
    }
    if (dataDisks != null) {
        this.dataDisks = new ArrayList();
        for (DataDisk item : dataDisks) {
          this.addToDataDisks(item);
        }
    } else {
      this.dataDisks = null;
    }
    return (A) this;
  }
  
  public A withDataDisks(io.fabric8.openshift.api.model.installer.nutanix.v1.DataDisk... dataDisks) {
    if (this.dataDisks != null) {
        this.dataDisks.clear();
        _visitables.remove("dataDisks");
    }
    if (dataDisks != null) {
      for (DataDisk item : dataDisks) {
        this.addToDataDisks(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDataDisks() {
    return this.dataDisks != null && !this.dataDisks.isEmpty();
  }
  
  public DataDisksNested<A> addNewDataDisk() {
    return new DataDisksNested(-1, null);
  }
  
  public DataDisksNested<A> addNewDataDiskLike(DataDisk item) {
    return new DataDisksNested(-1, item);
  }
  
  public DataDisksNested<A> setNewDataDiskLike(int index,DataDisk item) {
    return new DataDisksNested(index, item);
  }
  
  public DataDisksNested<A> editDataDisk(int index) {
    if (dataDisks.size() <= index) throw new RuntimeException("Can't edit dataDisks. Index exceeds size.");
    return setNewDataDiskLike(index, buildDataDisk(index));
  }
  
  public DataDisksNested<A> editFirstDataDisk() {
    if (dataDisks.size() == 0) throw new RuntimeException("Can't edit first dataDisks. The list is empty.");
    return setNewDataDiskLike(0, buildDataDisk(0));
  }
  
  public DataDisksNested<A> editLastDataDisk() {
    int index = dataDisks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dataDisks. The list is empty.");
    return setNewDataDiskLike(index, buildDataDisk(index));
  }
  
  public DataDisksNested<A> editMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dataDisks.size();i++) { 
    if (predicate.test(dataDisks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dataDisks. No match found.");
    return setNewDataDiskLike(index, buildDataDisk(index));
  }
  
  public A addToFailureDomains(int index,String item) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<String>();}
    this.failureDomains.add(index, item);
    return (A)this;
  }
  
  public A setToFailureDomains(int index,String item) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<String>();}
    this.failureDomains.set(index, item); return (A)this;
  }
  
  public A addToFailureDomains(java.lang.String... items) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<String>();}
    for (String item : items) {this.failureDomains.add(item);} return (A)this;
  }
  
  public A addAllToFailureDomains(Collection<String> items) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<String>();}
    for (String item : items) {this.failureDomains.add(item);} return (A)this;
  }
  
  public A removeFromFailureDomains(java.lang.String... items) {
    if (this.failureDomains == null) return (A)this;
    for (String item : items) { this.failureDomains.remove(item);} return (A)this;
  }
  
  public A removeAllFromFailureDomains(Collection<String> items) {
    if (this.failureDomains == null) return (A)this;
    for (String item : items) { this.failureDomains.remove(item);} return (A)this;
  }
  
  public List<String> getFailureDomains() {
    return this.failureDomains;
  }
  
  public String getFailureDomain(int index) {
    return this.failureDomains.get(index);
  }
  
  public String getFirstFailureDomain() {
    return this.failureDomains.get(0);
  }
  
  public String getLastFailureDomain() {
    return this.failureDomains.get(failureDomains.size() - 1);
  }
  
  public String getMatchingFailureDomain(Predicate<String> predicate) {
      for (String item : failureDomains) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingFailureDomain(Predicate<String> predicate) {
      for (String item : failureDomains) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFailureDomains(List<String> failureDomains) {
    if (failureDomains != null) {
        this.failureDomains = new ArrayList();
        for (String item : failureDomains) {
          this.addToFailureDomains(item);
        }
    } else {
      this.failureDomains = null;
    }
    return (A) this;
  }
  
  public A withFailureDomains(java.lang.String... failureDomains) {
    if (this.failureDomains != null) {
        this.failureDomains.clear();
        _visitables.remove("failureDomains");
    }
    if (failureDomains != null) {
      for (String item : failureDomains) {
        this.addToFailureDomains(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFailureDomains() {
    return this.failureDomains != null && !this.failureDomains.isEmpty();
  }
  
  public A addToGpus(int index,NutanixGPU item) {
    if (this.gpus == null) {this.gpus = new ArrayList<NutanixGPU>();}
    this.gpus.add(index, item);
    return (A)this;
  }
  
  public A setToGpus(int index,NutanixGPU item) {
    if (this.gpus == null) {this.gpus = new ArrayList<NutanixGPU>();}
    this.gpus.set(index, item); return (A)this;
  }
  
  public A addToGpus(io.fabric8.openshift.api.model.machine.v1.NutanixGPU... items) {
    if (this.gpus == null) {this.gpus = new ArrayList<NutanixGPU>();}
    for (NutanixGPU item : items) {this.gpus.add(item);} return (A)this;
  }
  
  public A addAllToGpus(Collection<NutanixGPU> items) {
    if (this.gpus == null) {this.gpus = new ArrayList<NutanixGPU>();}
    for (NutanixGPU item : items) {this.gpus.add(item);} return (A)this;
  }
  
  public A removeFromGpus(io.fabric8.openshift.api.model.machine.v1.NutanixGPU... items) {
    if (this.gpus == null) return (A)this;
    for (NutanixGPU item : items) { this.gpus.remove(item);} return (A)this;
  }
  
  public A removeAllFromGpus(Collection<NutanixGPU> items) {
    if (this.gpus == null) return (A)this;
    for (NutanixGPU item : items) { this.gpus.remove(item);} return (A)this;
  }
  
  public List<NutanixGPU> getGpus() {
    return this.gpus;
  }
  
  public NutanixGPU getGpus(int index) {
    return this.gpus.get(index);
  }
  
  public NutanixGPU getFirstGpus() {
    return this.gpus.get(0);
  }
  
  public NutanixGPU getLastGpus() {
    return this.gpus.get(gpus.size() - 1);
  }
  
  public NutanixGPU getMatchingGpus(Predicate<NutanixGPU> predicate) {
      for (NutanixGPU item : gpus) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingGpus(Predicate<NutanixGPU> predicate) {
      for (NutanixGPU item : gpus) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGpus(List<NutanixGPU> gpus) {
    if (gpus != null) {
        this.gpus = new ArrayList();
        for (NutanixGPU item : gpus) {
          this.addToGpus(item);
        }
    } else {
      this.gpus = null;
    }
    return (A) this;
  }
  
  public A withGpus(io.fabric8.openshift.api.model.machine.v1.NutanixGPU... gpus) {
    if (this.gpus != null) {
        this.gpus.clear();
        _visitables.remove("gpus");
    }
    if (gpus != null) {
      for (NutanixGPU item : gpus) {
        this.addToGpus(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGpus() {
    return this.gpus != null && !this.gpus.isEmpty();
  }
  
  public A addNewGpus(Integer deviceID,String name,String type) {
    return (A)addToGpus(new NutanixGPU(deviceID, name, type));
  }
  
  public Long getMemoryMiB() {
    return this.memoryMiB;
  }
  
  public A withMemoryMiB(Long memoryMiB) {
    this.memoryMiB = memoryMiB;
    return (A) this;
  }
  
  public boolean hasMemoryMiB() {
    return this.memoryMiB != null;
  }
  
  public OSDisk buildOsDisk() {
    return this.osDisk != null ? this.osDisk.build() : null;
  }
  
  public A withOsDisk(OSDisk osDisk) {
    this._visitables.remove("osDisk");
    if (osDisk != null) {
        this.osDisk = new OSDiskBuilder(osDisk);
        this._visitables.get("osDisk").add(this.osDisk);
    } else {
        this.osDisk = null;
        this._visitables.get("osDisk").remove(this.osDisk);
    }
    return (A) this;
  }
  
  public boolean hasOsDisk() {
    return this.osDisk != null;
  }
  
  public A withNewOsDisk(Long diskSizeGiB) {
    return (A)withOsDisk(new OSDisk(diskSizeGiB));
  }
  
  public OsDiskNested<A> withNewOsDisk() {
    return new OsDiskNested(null);
  }
  
  public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
    return new OsDiskNested(item);
  }
  
  public OsDiskNested<A> editOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(null));
  }
  
  public OsDiskNested<A> editOrNewOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(new OSDiskBuilder().build()));
  }
  
  public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(item));
  }
  
  public NutanixResourceIdentifier getProject() {
    return this.project;
  }
  
  public A withProject(NutanixResourceIdentifier project) {
    this.project = project;
    return (A) this;
  }
  
  public boolean hasProject() {
    return this.project != null;
  }
  
  public A withNewProject(String name,String type,String uuid) {
    return (A)withProject(new NutanixResourceIdentifier(name, type, uuid));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(bootType, that.bootType)) return false;
    if (!java.util.Objects.equals(categories, that.categories)) return false;
    if (!java.util.Objects.equals(coresPerSocket, that.coresPerSocket)) return false;
    if (!java.util.Objects.equals(cpus, that.cpus)) return false;
    if (!java.util.Objects.equals(dataDisks, that.dataDisks)) return false;
    if (!java.util.Objects.equals(failureDomains, that.failureDomains)) return false;
    if (!java.util.Objects.equals(gpus, that.gpus)) return false;
    if (!java.util.Objects.equals(memoryMiB, that.memoryMiB)) return false;
    if (!java.util.Objects.equals(osDisk, that.osDisk)) return false;
    if (!java.util.Objects.equals(project, that.project)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bootType,  categories,  coresPerSocket,  cpus,  dataDisks,  failureDomains,  gpus,  memoryMiB,  osDisk,  project,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootType != null) { sb.append("bootType:"); sb.append(bootType + ","); }
    if (categories != null && !categories.isEmpty()) { sb.append("categories:"); sb.append(categories + ","); }
    if (coresPerSocket != null) { sb.append("coresPerSocket:"); sb.append(coresPerSocket + ","); }
    if (cpus != null) { sb.append("cpus:"); sb.append(cpus + ","); }
    if (dataDisks != null && !dataDisks.isEmpty()) { sb.append("dataDisks:"); sb.append(dataDisks + ","); }
    if (failureDomains != null && !failureDomains.isEmpty()) { sb.append("failureDomains:"); sb.append(failureDomains + ","); }
    if (gpus != null && !gpus.isEmpty()) { sb.append("gpus:"); sb.append(gpus + ","); }
    if (memoryMiB != null) { sb.append("memoryMiB:"); sb.append(memoryMiB + ","); }
    if (osDisk != null) { sb.append("osDisk:"); sb.append(osDisk + ","); }
    if (project != null) { sb.append("project:"); sb.append(project + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DataDisksNested<N> extends DataDiskFluent<DataDisksNested<N>> implements Nested<N>{
    DataDisksNested(int index,DataDisk item) {
      this.index = index;
      this.builder = new DataDiskBuilder(this, item);
    }
    DataDiskBuilder builder;
    int index;
    
    public N and() {
      return (N) MachinePoolFluent.this.setToDataDisks(index,builder.build());
    }
    
    public N endDataDisk() {
      return and();
    }
    
  
  }
  public class OsDiskNested<N> extends OSDiskFluent<OsDiskNested<N>> implements Nested<N>{
    OsDiskNested(OSDisk item) {
      this.builder = new OSDiskBuilder(this, item);
    }
    OSDiskBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withOsDisk(builder.build());
    }
    
    public N endOsDisk() {
      return and();
    }
    
  
  }

}