package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class UEFISettingsBuilder extends UEFISettingsFluent<UEFISettingsBuilder> implements VisitableBuilder<UEFISettings,UEFISettingsBuilder>{
  public UEFISettingsBuilder() {
    this(new UEFISettings());
  }
  
  public UEFISettingsBuilder(UEFISettingsFluent<?> fluent) {
    this(fluent, new UEFISettings());
  }
  
  public UEFISettingsBuilder(UEFISettingsFluent<?> fluent,UEFISettings instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public UEFISettingsBuilder(UEFISettings instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  UEFISettingsFluent<?> fluent;
  
  public UEFISettings build() {
    UEFISettings buildable = new UEFISettings(fluent.getSecureBoot(),fluent.getVirtualizedTrustedPlatformModule());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}