package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PlatformBuilder extends PlatformFluent<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(new Platform());
  }
  
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, new Platform());
  }
  
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PlatformBuilder(Platform instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PlatformFluent<?> fluent;
  
  public Platform build() {
    Platform buildable = new Platform(fluent.getArmEndpoint(),fluent.getBaseDomainResourceGroupName(),fluent.getCloudName(),fluent.getClusterOSImage(),fluent.getComputeSubnet(),fluent.getControlPlaneSubnet(),fluent.buildCustomerManagedKey(),fluent.buildDefaultMachinePlatform(),fluent.getNetworkResourceGroupName(),fluent.getOutboundType(),fluent.getRegion(),fluent.getResourceGroupName(),fluent.getUserTags(),fluent.getVirtualNetwork());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}