package io.fabric8.openshift.api.model.installer.azure.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MetadataFluent<A extends MetadataFluent<A>> extends BaseFluent<A>{
  public MetadataFluent() {
  }
  
  public MetadataFluent(Metadata instance) {
    this.copyInstance(instance);
  }
  private String armEndpoint;
  private String baseDomainResourceGroupName;
  private String cloudName;
  private String region;
  private String resourceGroupName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Metadata instance) {
    instance = (instance != null ? instance : new Metadata());
    if (instance != null) {
          this.withArmEndpoint(instance.getArmEndpoint());
          this.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName());
          this.withCloudName(instance.getCloudName());
          this.withRegion(instance.getRegion());
          this.withResourceGroupName(instance.getResourceGroupName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getArmEndpoint() {
    return this.armEndpoint;
  }
  
  public A withArmEndpoint(String armEndpoint) {
    this.armEndpoint = armEndpoint;
    return (A) this;
  }
  
  public boolean hasArmEndpoint() {
    return this.armEndpoint != null;
  }
  
  public String getBaseDomainResourceGroupName() {
    return this.baseDomainResourceGroupName;
  }
  
  public A withBaseDomainResourceGroupName(String baseDomainResourceGroupName) {
    this.baseDomainResourceGroupName = baseDomainResourceGroupName;
    return (A) this;
  }
  
  public boolean hasBaseDomainResourceGroupName() {
    return this.baseDomainResourceGroupName != null;
  }
  
  public String getCloudName() {
    return this.cloudName;
  }
  
  public A withCloudName(String cloudName) {
    this.cloudName = cloudName;
    return (A) this;
  }
  
  public boolean hasCloudName() {
    return this.cloudName != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public String getResourceGroupName() {
    return this.resourceGroupName;
  }
  
  public A withResourceGroupName(String resourceGroupName) {
    this.resourceGroupName = resourceGroupName;
    return (A) this;
  }
  
  public boolean hasResourceGroupName() {
    return this.resourceGroupName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MetadataFluent that = (MetadataFluent) o;
    if (!java.util.Objects.equals(armEndpoint, that.armEndpoint)) return false;
    if (!java.util.Objects.equals(baseDomainResourceGroupName, that.baseDomainResourceGroupName)) return false;
    if (!java.util.Objects.equals(cloudName, that.cloudName)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(resourceGroupName, that.resourceGroupName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(armEndpoint,  baseDomainResourceGroupName,  cloudName,  region,  resourceGroupName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (armEndpoint != null) { sb.append("armEndpoint:"); sb.append(armEndpoint + ","); }
    if (baseDomainResourceGroupName != null) { sb.append("baseDomainResourceGroupName:"); sb.append(baseDomainResourceGroupName + ","); }
    if (cloudName != null) { sb.append("cloudName:"); sb.append(cloudName + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (resourceGroupName != null) { sb.append("resourceGroupName:"); sb.append(resourceGroupName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}