package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DiskEncryptionSetBuilder extends DiskEncryptionSetFluent<DiskEncryptionSetBuilder> implements VisitableBuilder<DiskEncryptionSet,DiskEncryptionSetBuilder>{
  public DiskEncryptionSetBuilder() {
    this(new DiskEncryptionSet());
  }
  
  public DiskEncryptionSetBuilder(DiskEncryptionSetFluent<?> fluent) {
    this(fluent, new DiskEncryptionSet());
  }
  
  public DiskEncryptionSetBuilder(DiskEncryptionSetFluent<?> fluent,DiskEncryptionSet instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DiskEncryptionSetBuilder(DiskEncryptionSet instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DiskEncryptionSetFluent<?> fluent;
  
  public DiskEncryptionSet build() {
    DiskEncryptionSet buildable = new DiskEncryptionSet(fluent.getName(),fluent.getResourceGroup(),fluent.getSubscriptionId());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}